package com.ejianc.business.assist.store.consts;

/**
 * @author songlx
 * @version 1.0
 * @description: 公共常量
 * @date 2021/11/17
 */
public class StoreCommonConsts {

    /**
     *  广义数字
     */

    public static final Integer ZERO = 0;

    public static final Integer ONE = 1;

    public static final Integer TWO = 2;

    public static final Integer THREE = 3;

    /**
     * 广义是否
     */
    public static final Integer YES = 1;

    public static final Integer NO = 0;

    /**
     * 出入库标志 : 入库
     */
    public static final Integer IN_OUT_TYPE_IN = 1;

    /**
     * 出入库标志 : 出库
     */
    public static final Integer IN_OUT_TYPE_OUT = 2;


    /**
     * @author songlx
     * @description: 针对入库出库使用状态
     * 0无需出库 出库单标识
     * 1可以出库 入库单可以使用
     * 2出库占用中 入库单
     * 3出库完成 入库单
     * @date: 2022/1/25
     */
    public static class UseOutFlag {

        /**
         * 1可以出库,入库单已生效,未使用
         */
        public static final Integer USEABLE = 1;

        /**
         * 2出库占用中
         */
        public static final Integer USEING = 2;

        /**
         * 3出库完成,入库单占用完毕
         */
        public static final Integer USE_FINISH = 3;
    }

}
