package com.ejianc.business.outrmat.start.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 启用单材料明细实体
 * 
 * @author generator
 * 
 */
public class OutRmatStartDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long startId; // 启用单主键
    private Long materialTypeId; // 物资分类主键
    private String materialTypeName; // 物资分类名称
    private Long materialId; // 物料主键
    private String materialCode; // 物料编码
    private String materialName; // 物料名称
    private String spec; // 规格/型号
    private Long unitId; // 计量单位主键
    private String unitName; // 计量单位
    private BigDecimal num; // 数量
    private BigDecimal enableNum; // 可启用数量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime; // 启用时间
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    private String memo; // 备注
    private String sourceId; // 来源主键
    private Long unitMId; // 计量单位主键
    private String unitMName; // 计量单位
    private BigDecimal numM; // 计量数量
    private BigDecimal transScale; // 转换系数
    private Long storeId; // 仓库主键
    private String storeName; // 仓库名称
    private Integer sourceType; // 材料来源,0-自购,1-租赁

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public Long getStartId() {
        return startId;
    }

    public void setStartId(Long startId) {
        this.startId = startId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    @ReferSerialTransfer(referCode = "share-unit")
    public Long getUnitId() {
        return unitId;
    }
    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getEnableNum() {
        return enableNum;
    }

    public void setEnableNum(BigDecimal enableNum) {
        this.enableNum = enableNum;
    }
    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }
    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Long getUnitMId() {
        return unitMId;
    }

    public void setUnitMId(Long unitMId) {
        this.unitMId = unitMId;
    }

    public String getUnitMName() {
        return unitMName;
    }

    public void setUnitMName(String unitMName) {
        this.unitMName = unitMName;
    }

    public BigDecimal getNumM() {
        return numM;
    }

    public void setNumM(BigDecimal numM) {
        this.numM = numM;
    }

    public BigDecimal getTransScale() {
        return transScale;
    }

    public void setTransScale(BigDecimal transScale) {
        this.transScale = transScale;
    }
}
