package com.ejianc.business.assist.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.bean.CheckEntity;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.ICheckService;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.assist.rmat.vo.CheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 验收单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICheckService service;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/prormat/check/card";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveOrUpdateVO) {
        CheckVO checkVO = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",checkVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(Long id) {
    	CheckEntity entity = service.selectById(id);
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("orgId") == null || param.getParams().get("orgId").getValue() == null) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<CheckVO> records = BeanMapper.mapList(page.getRecords(), CheckVO.class);
        records.forEach(vo->{
            if(BillStateEnum.COMMITED_STATE.getBillStateCode() == vo.getBillState()
                    || BillStateEnum.PASSED_STATE.getBillStateCode() == vo.getBillState()){
                vo.setShareBtnVisible(true);
            } else {
                vo.setShareBtnVisible(false);
            }
        });
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }


    @GetMapping(value = "/getBillShareLink")
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        CheckEntity entity = service.selectById(id);
        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus())
                && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //未曾成功推送单据，则先向供方推送单据
            boolean pushResult = service.pushBillToSupCenter(entity);
            if(!pushResult) {
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
        }
        return shareCooperateApi.getShareLink(id, BillTypeEnum.验收单.getCode(), entity.getSupplierId().toString(),
                mobileBillShareFrontUrl, null);
    }

    @Autowired
    private CheckBpmServiceImpl checkBpmService;

    @GetMapping(value = "/test")
    @ResponseBody
    public void test(Long id) {
        checkBpmService.afterApprovalProcessor(id,null,null);
    }

}
