package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.LoseEntity;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.mapper.SettleMapper;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.ILoseService;
import com.ejianc.business.assist.rmat.service.IRestituteService;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.vo.LoseVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.assist.rmat.vo.record.SettleRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService{

    private static final String PRO_RMAT_SETTLE = "PRO_RMAT_SETTLE";//此处需要根据实际修改


    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IRestituteService restituteService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private IContractService contractService;
    
    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(PRO_RMAT_SETTLE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            
            // 签字状态
            entity.setSupplierSignStatus(0);
        }
        
        // 校验合同
        validateContract(entity.getContractId(), entity.getId());
        // 校验结算日期
        SettleVO lastVo = queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null) {
            int compareDate = DateUtil.compareDate(lastVo.getSettleDate(), entity.getSettleDate());
            if (compareDate > 0) {
                throw new BusinessException("本次结算日期" + DateUtil.formatDate(entity.getSettleDate()) + "不能小于上次结算日期" + DateUtil.formatDate(lastVo.getSettleDate()));
            }
        }
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(selectById(entity.getId()), SettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(billId != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<SettleEntity> list = super.queryList(queryParam, false);
        if (ListUtil.isNotEmpty(list)) {
            throw new BusinessException("当前合同存在非审批通过态的结算单，不允许新增!");
        }
        return "校验通过！";
    }
    
    @Override
    public List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<RestituteEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RestituteEntity::getContractId, contractId);
        wrapper.eq(RestituteEntity::getSettleFlag, 0);
        wrapper.in(RestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(RestituteEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(RestituteEntity::getSubmitTime, settleDate);
        }else {
            wrapper.between(RestituteEntity::getSubmitTime, lastSettleDate, settleDate);
        }

        List<RestituteEntity> list = restituteService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, RestituteVO.class);
        }
    }

    @Override
    public List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper<LoseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(LoseEntity::getContractId, contractId);
        wrapper.eq(LoseEntity::getSettleFlag, 0);
        wrapper.in(LoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(LoseEntity::getCreateTime);
        if (StringUtils.isBlank(lastSettleDate)) {
            wrapper.le(LoseEntity::getSubmitTime, settleDate);
        }else {
            wrapper.between(LoseEntity::getSubmitTime, lastSettleDate, settleDate);
        }
        
        List<LoseEntity> list = loseService.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new ArrayList<>();
        }else {
            return BeanMapper.mapList(list, LoseVO.class);
        }
        
    }

    @Override
    public SettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, contractId);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        if(billId != null){
            wrapper.ne(SettleEntity::getId, billId);
        }
        wrapper.orderByDesc(SettleEntity::getCreateTime);
        
        List<SettleEntity> list = this.list(wrapper);

        if (ListUtil.isEmpty(list)) {
            return new SettleVO();
        }else {
            return BeanMapper.map(list.get(0), SettleVO.class);
        }
        
    }

    @Override
    public SettleRecordVO querySettleRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);

        SettleRecordVO vo = new SettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());

        // 查询变更记录
        LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SettleEntity::getContractId, id);
        wrapper.orderByDesc(SettleEntity::getCreateTime);
        List<SettleEntity> settleList = super.list(wrapper);
        
        if (ListUtil.isNotEmpty(settleList)) {
            vo.setTotalSettleTaxMny(settleList.get(0).getTotalSettleTaxMny());
            vo.setTotalSettleMny(settleList.get(0).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getTotalSettleTaxMny(), vo.getTotalSettleMny()), new BigDecimal("100")));
        }

        vo.setDetailList(BeanMapper.mapList(settleList, SettleVO.class));
        
        return vo;
    }
}
