/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.BatchPlanDetailEntity;
import com.ejianc.business.assist.rmat.bean.BatchPlanEntity;
import com.ejianc.business.assist.rmat.mapper.BatchPlanMapper;
import com.ejianc.business.assist.rmat.service.IBatchPlanDetailService;
import com.ejianc.business.assist.rmat.service.IBatchPlanService;
import com.ejianc.business.assist.rmat.vo.BatchPlanDetailVO;
import com.ejianc.business.assist.rmat.vo.BatchPlanEnum;
import com.ejianc.business.assist.rmat.vo.BatchPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="batchPlanService")
public class BatchPlanServiceImpl
extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity>
implements IBatchPlanService {
    private static final String BILL_CODE = "PRO_BATCH_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBatchPlanDetailService batchPlanDetailService;

    @Override
    public BatchPlanVO saveOrUpdate(BatchPlanVO saveorUpdateVO) {
        List detailEntityList;
        Long tenantId = InvocationInfoProxy.getTenantid();
        BatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(Integer.valueOf(0));
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (BatchPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BatchPlanEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (BatchPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, BatchPlanEntity.class));
            operateType = "add";
        }
        List detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        ArrayList<String> nameList = new ArrayList<String>();
        for (BatchPlanDetailVO detailVO : detailList) {
            if (nameList.contains(detailVO.getMaterialTypeName())) continue;
            categoryName = categoryName.length() > 0 ? categoryName + "," + detailVO.getMaterialTypeName() : detailVO.getMaterialTypeName();
            nameList.add(detailVO.getMaterialTypeName());
            if (categoryName.length() <= 100) continue;
            break;
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((BatchPlanMapper)this.baseMapper).delByBatchId(entity.getId());
        }
        if ((detailEntityList = BeanMapper.mapList((Iterable)detailList, BatchPlanDetailEntity.class)).size() > 0) {
            for (BatchPlanDetailEntity detailEntity : detailEntityList) {
                detailEntity.setBatchId(entity.getId());
            }
            this.batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public BatchPlanVO queryDetail(Long id) {
        BatchPlanEntity batchPlanEntity = (BatchPlanEntity)((Object)super.selectById((Serializable)id));
        BatchPlanVO vo = (BatchPlanVO)BeanMapper.map((Object)((Object)batchPlanEntity), BatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)BatchPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (BatchPlanEntity entity : entityList) {
                if (BatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + entity.getProjectName() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setTenderStatus(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }
}

