package com.ejianc.business.assist.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 周转材租赁合同-工程量租明细表更表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistrmat_contract_change_num_rent")
public class ChangeNumRentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_type")
    private String changeType; // 变更类型
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="source_id")
    private Long sourceId; // 来源数据Id(参照数据id)
    @TableField(value="source_bid")
    private Long sourceBid; // 来源子表主键(合同子表id)
    @TableField(value="source_type")
    private String sourceType; // 来源类型：0-定标结果带入，1-总计划，2-材料档案，3-批次计划
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资材料分类Id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资材料分类名称
    @TableField(value="material_name")
    private String materialName; // 材料名称
    @TableField(value="spec")
    private String spec; // 规则/型号
    @TableField(value="count")
    private BigDecimal count; // 数量
    @TableField(value="unit_price")
    private BigDecimal unitPrice; // 单价(无税)
    @TableField(value="unit_tax_price")
    private BigDecimal unitTaxPrice; // 单价
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="tax")
    private BigDecimal tax; // 税额
    @TableField(value="lose_unit_price")
    private BigDecimal loseUnitPrice; // 遗失单价(无税)
    @TableField(value="lose_unit_tax_price")
    private BigDecimal loseUnitTaxPrice; // 遗失单价
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 计划进场时间
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 计划出场时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_id")
    private Long materialId; // 材料id
    @TableField(value="material_code")
    private String materialCode; // 材料编码
    @TableField(value="unit_id")
    private Long unitId; // 计量单位id
    @TableField(value="unit_name")
    private String unitName; // 计量单位名称

    @TableField(value = "surplus_count")
    private BigDecimal surplusCount; // 剩余数量
    

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeType() {
        return changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    
    public BigDecimal getCount() {
        return count;
    }

    public void setCount(BigDecimal count) {
        this.count = count;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getUnitTaxPrice() {
        return unitTaxPrice;
    }

    public void setUnitTaxPrice(BigDecimal unitTaxPrice) {
        this.unitTaxPrice = unitTaxPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    public BigDecimal getLoseUnitPrice() {
        return loseUnitPrice;
    }

    public void setLoseUnitPrice(BigDecimal loseUnitPrice) {
        this.loseUnitPrice = loseUnitPrice;
    }
    public BigDecimal getLoseUnitTaxPrice() {
        return loseUnitTaxPrice;
    }

    public void setLoseUnitTaxPrice(BigDecimal loseUnitTaxPrice) {
        this.loseUnitTaxPrice = loseUnitTaxPrice;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getSurplusCount() {
        return surplusCount;
    }

    public void setSurplusCount(BigDecimal surplusCount) {
        this.surplusCount = surplusCount;
    }
    
}
