package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.CheckVO;
import com.ejianc.business.assist.rmat.vo.StartDetailVO;
import com.ejianc.business.assist.rmat.vo.StartVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.CheckMapper;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 验收单
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    private static final String BILL_CODE = "PRORMAT_CHECK";//此处需要根据实际修改

    private static final String OPERATE = "CHECK_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.验收单.getCode();
    private static final String BILL_NAME = BillTypeEnum.验收单.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billDel";

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    @Transactional
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {

        // 同一个合同只能存在一个自由态或审批中的单据
        materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        this.validateTime(saveOrUpdateVO, MaterialConstant.保存);


        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //保存单据制单人Id
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (null == entity.getSupplierSignStatus()){
            entity.setSupplierSignStatus(SupplierSignStatusEnum.乙方未签字.getCode());
        }
        super.saveOrUpdate(entity, false);


        String checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_WAIT;
        DeliveryEntity deliveryEntity = deliveryService.selectById(entity.getDeliveryId());

        //回写发货单数据
        if ("1".equals(entity.getCheckSource())) {
            //查询出所有的验收单详情,算出验收数据
            LambdaQueryWrapper<CheckDetailEntity> lambdaCheckDetail = Wrappers.<CheckDetailEntity>lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId,entity.getDeliveryId());
            List<CheckDetailEntity> checkDetailEntityList = checkDetailService.list(lambdaCheckDetail);
            if(CollectionUtils.isNotEmpty(checkDetailEntityList)){
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper<DeliveryDetailEntity> lambdaDeliveryDetail = Wrappers.<DeliveryDetailEntity>lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId,entity.getDeliveryId());
                List<DeliveryDetailEntity> deliveryDetailEntityList = deliveryDetailService.list(lambdaDeliveryDetail);

                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList){
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)){
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNumsSum(checkNum);
                    }
                    if (null == deliveryDetailEntity.getCheckNumsSum()){
                        deliveryDetailEntity.setCheckNumsSum(BigDecimal.ZERO);
                    }
                }
                //判断发货单的验收状态
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> (e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1) &&
                        (e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1));

                if (allCheck){
                    checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_ALL;
                }
                if (anyCheck){
                    checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_PART;
                }
                //推送供方改状态
                deliveryEntity.setAcceptanceState(checkStatus);
                //更新发货验收状态和验收数量
                String msg = deliveryService.updateBillConfirmState(deliveryEntity);
                if (null!=msg){
                    throw new BusinessException("推送失败");
                }
                deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
        }
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }


    @Override
    public void delete(List<CheckVO> vos) {
        //删除回写逻辑, 回写发货单子表数据
        if (vos.size() > 1){
            throw new BusinessException("验收单不允许批量删除!");
        }
        CheckVO checkVO = vos.get(0);

        CheckEntity checkEntity = super.selectById(checkVO.getId());
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        DeliveryEntity deliveryEntity = deliveryService.selectById(checkEntity.getDeliveryId());
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        Map<Long, CheckDetailEntity> checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList){
            if(checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())){
                CheckDetailEntity checkDetailEntity = checkDetailEntityMap.get(deliveryDetailEntity.getId());
                deliveryDetailEntity.setCheckNumsSum(deliveryDetailEntity.getCheckNumsSum().subtract(checkDetailEntity.getCheckNumsSum()));
            }
        }

        //判断发货单的验收状态
        Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getCheckNumsSum()) > -1);
        Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> (e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1) &&
                (e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1));
        String checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_WAIT;
        if (allCheck){
            checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_ALL;
        }
        if (anyCheck){
            checkStatus = CommonConstant.DELIVERY_ACCEPTANCE_PART;
        }
        //更新发货验收状态和验收数量
        deliveryEntity.setAcceptanceState(checkStatus);
        //更新发货验收状态和验收数量
        String msg = deliveryService.updateBillConfirmState(deliveryEntity);
        if (null!=msg){
            throw new BusinessException("推送失败");
        }
        deliveryDetailService.updateBatchById(deliveryDetailList);

        super.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()),true);
    }

    @Override
    public boolean pushBillToSupCenter(CheckEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        CheckEntity entity = super.selectById(billId);
        String msg = pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject) JSONObject.toJSON(entity),
                CheckEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(CheckEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }





    @Override
    public void submitChangeCheckNums(List<CheckDetailEntity> checkDetailList){
        for (CheckDetailEntity detailEntity:checkDetailList){
            DeliveryDetailEntity deliveryDetailEntity = deliveryDetailService.selectById(detailEntity.getDeliveryDetailId());
            BigDecimal checkNumsSum = MathUtil.safeAdd(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper<DeliveryDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryDetailEntity::getId,detailEntity.getDeliveryDetailId());
            wrapper.set(DeliveryDetailEntity::getCheckNumsSum,checkNumsSum);
            deliveryDetailService.update(wrapper);
        }
    }

    @Override
    public void backChangeCheckNums(List<CheckDetailEntity> checkDetailList){
        for (CheckDetailEntity detailEntity:checkDetailList){
            DeliveryDetailEntity deliveryDetailEntity = deliveryDetailService.selectById(detailEntity.getDeliveryDetailId());
            BigDecimal checkNumsSum = MathUtil.safeSub(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper<DeliveryDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryDetailEntity::getId,detailEntity.getDeliveryDetailId());
            wrapper.set(DeliveryDetailEntity::getCheckNumsSum,checkNumsSum);
            deliveryDetailService.update(wrapper);
        }
    }

    @Override
    public void submitChangeCheckState(Long deliveryId,List<CheckDetailEntity> detailEntities){
        Map<Long, CheckDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        DeliveryEntity deliveryEntity = deliveryService.selectById(deliveryId);
        Boolean allCheck = true;
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()){
           /* BigDecimal checkNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(deliveryDetailEntity.getId())){
                CheckDetailEntity detailEntity = collect.get(deliveryDetailEntity.getId());
                checkNumsSum = MathUtil.safeAdd(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            }else{
                checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            }*/
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            if (null==checkNumsSum||checkNumsSum.compareTo(deliveryDetailEntity.getDeliveredNumsSum()) == -1){
                allCheck = false;
            }
        }
        if (allCheck){
            LambdaUpdateWrapper<DeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryEntity::getId,deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_ALL);
            deliveryService.update(wrapper);
        }else{
            LambdaUpdateWrapper<DeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryEntity::getId,deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_PART);
            deliveryService.update(wrapper);
        }
    }

    @Override
    public void backChangeCheckState(Long deliveryId,List<CheckDetailEntity> detailEntities){
        Map<Long, CheckDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        DeliveryEntity deliveryEntity = deliveryService.selectById(deliveryId);
        Boolean waitCheck = true;
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()){
            /*BigDecimal checkNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(deliveryDetailEntity.getId())){
                CheckDetailEntity detailEntity = collect.get(deliveryDetailEntity.getId());
                checkNumsSum = MathUtil.safeSub(deliveryDetailEntity.getCheckNumsSum(),detailEntity.getCheckNumsSum());
            }else{
                checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            }*/
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            if (null==checkNumsSum||checkNumsSum.compareTo(BigDecimal.ZERO) == 1){
                waitCheck = false;
            }
        }
        if (waitCheck){
            LambdaUpdateWrapper<DeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryEntity::getId,deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_WAIT);
            deliveryService.update(wrapper);
        }else{
            LambdaUpdateWrapper<DeliveryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(DeliveryEntity::getId,deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, CommonConstant.DELIVERY_ACCEPTANCE_PART);
            deliveryService.update(wrapper);
        }
    }

    /**
     * 校验必须大于最大单据日期
     * @param checkVO
     * @param type
     * @return
     */
    public String validateTime(CheckVO checkVO, String type) {
        Map<String, Object> params = new HashMap<>();
        params.put("contractId", checkVO.getContractId());
        if(checkVO.getId() != null){
            params.put("billType", MaterialConstant.验收单);
            params.put("billId", checkVO.getId());
        }
        Date lastDate = materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = materialService.getMaxTime(params);

        if (lastDate == null) return "未获取最大单据日期！";
        if(ValidateUtil.compareDate(checkVO.getCheckDate(), lastDate, maxTimeMap, checkVO.getCheckDate())){
            throw new BusinessException(DateUtil.formatDate(checkVO.getCheckDate())
                    + "验收日期小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }
        if(ValidateUtil.compareDate(checkVO.getRmatDate(), lastDate, maxTimeMap, checkVO.getRmatDate())){
            throw new BusinessException(DateUtil.formatDate(checkVO.getRmatDate())
                    + "计租日期小于最大单据日期【" + DateUtil.formatDate(lastDate) + "】，不允许" + type + "!");
        }

        return "校验通过！";
    }


}
