package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanDetailHistoryEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanDetailHistoryService;
import com.ejianc.business.assist.rmat.utils.SortUtil;
import com.ejianc.business.assist.rmat.utils.TreeNodeBUtil;
import com.ejianc.business.assist.rmat.vo.TotalPlanDetailHistoryVO;
import com.ejianc.business.assist.rmat.vo.TotalPlanHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.TotalPlanHistoryMapper;
import com.ejianc.business.assist.rmat.bean.TotalPlanHistoryEntity;
import com.ejianc.business.assist.rmat.service.ITotalPlanHistoryService;

import java.util.Collections;
import java.util.List;

/**
 * 周转材总计划历史
 * 
 * @author generator
 * 
 */
@Service("totalPlanHistoryService")
public class TotalPlanHistoryServiceImpl extends BaseServiceImpl<TotalPlanHistoryMapper, TotalPlanHistoryEntity> implements ITotalPlanHistoryService{

    @Autowired
    private ITotalPlanDetailHistoryService historyDetailService;

    @Override
    public TotalPlanHistoryVO queryDetailByChangeId(Long id) {
        TotalPlanHistoryEntity historyEntity = baseMapper.selectOne(new QueryWrapper<TotalPlanHistoryEntity>().eq("change_id", id));
        if (historyEntity != null) {
            TotalPlanHistoryVO historyVo = BeanMapper.map(historyEntity, TotalPlanHistoryVO.class);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("history_id", new Parameter(QueryParam.EQ, historyEntity.getId()));
            //queryParam.getParams().put("change_type", new Parameter(QueryParam.NE, 5));
            //queryParam.getOrderMap().put("detailIndex", "asc");
            List<TotalPlanDetailHistoryEntity> historyDetailEntities = historyDetailService.queryList(queryParam, false);

            if (historyDetailEntities != null && historyDetailEntities.size() > 0) {
                List<TotalPlanDetailHistoryVO> detailVos = BeanMapper.mapList(historyDetailEntities, TotalPlanDetailHistoryVO.class);

                for (TotalPlanDetailHistoryVO cdEntity : detailVos) {
                    cdEntity.setId(cdEntity.getTotalBid());
                    cdEntity.setTid(cdEntity.getTotalBid().toString());
                    cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                }
                //实现排序
                new SortUtil<TotalPlanDetailHistoryVO>().entryListToSort(detailVos, "treeIndex");
                historyVo.setDetailList(TreeNodeBUtil.buildTree(detailVos));
            }
            return historyVo;
        }
        return null;
    }
}
