/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.bean.CheckDetailEntity;
import com.ejianc.business.assist.rmat.bean.CheckEntity;
import com.ejianc.business.assist.rmat.bean.DeliveryDetailEntity;
import com.ejianc.business.assist.rmat.bean.DeliveryEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.mapper.CheckMapper;
import com.ejianc.business.assist.rmat.service.ICheckDetailService;
import com.ejianc.business.assist.rmat.service.ICheckService;
import com.ejianc.business.assist.rmat.service.IDeliveryDetailService;
import com.ejianc.business.assist.rmat.service.IDeliveryService;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.assist.rmat.vo.CheckVO;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private static final String BILL_CODE = "PRORMAT_CHECK";
    private static final String OPERATE = "CHECK_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u9a8c\u6536\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u9a8c\u6536\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/check/billDel";
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    @Transactional
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        if (null == entity.getSupplierSignStatus()) {
            entity.setSupplierSignStatus(SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode());
        }
        super.saveOrUpdate((Object)entity, false);
        String checkStatus = "0";
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
        if ("1".equals(entity.getCheckSource())) {
            LambdaQueryWrapper lambdaCheckDetail = Wrappers.lambdaQuery();
            lambdaCheckDetail.eq(CheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.checkDetailService.list((Wrapper)lambdaCheckDetail);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNumsSum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNumsSum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNumsSum()) continue;
                    deliveryDetailEntity.setCheckNumsSum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = "2";
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = "1";
                }
                deliveryEntity.setAcceptanceState(checkStatus);
                String msg = this.deliveryService.updateBillConfirmState(deliveryEntity);
                if (null != msg) {
                    throw new BusinessException("\u63a8\u9001\u5931\u8d25");
                }
                this.deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    @Override
    public void delete(List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(checkEntity.getDeliveryId()));
        List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
        Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
            if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
            CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
            deliveryDetailEntity.setCheckNumsSum(deliveryDetailEntity.getCheckNumsSum().subtract(checkDetailEntity.getCheckNumsSum()));
        }
        Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNumsSum().compareTo(e.getCheckNumsSum()) > -1);
        Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNumsSum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNumsSum().compareTo(e.getDeliveredNumsSum()) == -1);
        String checkStatus = "0";
        if (allCheck.booleanValue()) {
            checkStatus = "2";
        }
        if (anyCheck.booleanValue()) {
            checkStatus = "1";
        }
        deliveryEntity.setAcceptanceState(checkStatus);
        String msg = this.deliveryService.updateBillConfirmState(deliveryEntity);
        if (null != msg) {
            throw new BusinessException("\u63a8\u9001\u5931\u8d25");
        }
        this.deliveryDetailService.updateBatchById(deliveryDetailList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public boolean pushBillToSupCenter(CheckEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String billId = request.getParameter("billId");
        CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        String msg = this.pushSupUtil.updateBillSupSignSyncInfo(request, (JSONObject)JSONObject.toJSON((Object)((Object)entity)), CheckEntity.class, OPERATE, BILL_TYPE, BILL_NAME);
        return msg;
    }

    @Override
    public boolean delPushBill(CheckEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    @Override
    public void submitChangeCheckNums(List<CheckDetailEntity> checkDetailList) {
        for (CheckDetailEntity detailEntity : checkDetailList) {
            DeliveryDetailEntity deliveryDetailEntity = (DeliveryDetailEntity)((Object)this.deliveryDetailService.selectById(detailEntity.getDeliveryDetailId()));
            BigDecimal checkNumsSum = MathUtil.safeAdd(deliveryDetailEntity.getCheckNumsSum(), detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getDeliveryDetailId());
            wrapper.set(DeliveryDetailEntity::getCheckNumsSum, (Object)checkNumsSum);
            this.deliveryDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeCheckNums(List<CheckDetailEntity> checkDetailList) {
        for (CheckDetailEntity detailEntity : checkDetailList) {
            DeliveryDetailEntity deliveryDetailEntity = (DeliveryDetailEntity)((Object)this.deliveryDetailService.selectById(detailEntity.getDeliveryDetailId()));
            BigDecimal checkNumsSum = MathUtil.safeSub(deliveryDetailEntity.getCheckNumsSum(), detailEntity.getCheckNumsSum());
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)detailEntity.getDeliveryDetailId());
            wrapper.set(DeliveryDetailEntity::getCheckNumsSum, (Object)checkNumsSum);
            this.deliveryDetailService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void submitChangeCheckState(Long deliveryId, List<CheckDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryId));
        Boolean allCheck = true;
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()) {
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            if (null != checkNumsSum && checkNumsSum.compareTo(deliveryDetailEntity.getDeliveredNumsSum()) != -1) continue;
            allCheck = false;
        }
        if (allCheck.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, (Object)"2");
            this.deliveryService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, (Object)"1");
            this.deliveryService.update((Wrapper)wrapper);
        }
    }

    @Override
    public void backChangeCheckState(Long deliveryId, List<CheckDetailEntity> detailEntities) {
        LambdaUpdateWrapper wrapper;
        Map collect = detailEntities.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity(), (k1, k2) -> k2));
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryId));
        Boolean waitCheck = true;
        for (DeliveryDetailEntity deliveryDetailEntity : deliveryEntity.getDeliveryDetailList()) {
            BigDecimal checkNumsSum = BigDecimal.ZERO;
            checkNumsSum = deliveryDetailEntity.getCheckNumsSum();
            if (null != checkNumsSum && checkNumsSum.compareTo(BigDecimal.ZERO) != 1) continue;
            waitCheck = false;
        }
        if (waitCheck.booleanValue()) {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, (Object)"0");
            this.deliveryService.update((Wrapper)wrapper);
        } else {
            wrapper = new LambdaUpdateWrapper();
            wrapper.eq(BaseEntity::getId, (Object)deliveryId);
            wrapper.set(DeliveryEntity::getAcceptanceState, (Object)"1");
            this.deliveryService.update((Wrapper)wrapper);
        }
    }

    public String validateTime(CheckVO checkVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", checkVO.getContractId());
        if (checkVO.getId() != null) {
            params.put("billType", "\u9a8c\u6536\u5355");
            params.put("billId", checkVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(checkVO.getCheckDate(), lastDate, maxTimeMap, checkVO.getCheckDate())) {
            throw new BusinessException(DateUtil.formatDate(checkVO.getCheckDate()) + "\u9a8c\u6536\u65e5\u671f\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (ValidateUtil.compareDate(checkVO.getRmatDate(), lastDate, maxTimeMap, checkVO.getRmatDate())) {
            throw new BusinessException(DateUtil.formatDate(checkVO.getRmatDate()) + "\u8ba1\u79df\u65e5\u671f\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

