package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.enums.*;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("contract") 
public class ContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IContractService service;
    
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		ContractEntity entity = service.selectById(billId);
		if (entity != null){
			if((DraftTypeEnum.线下签订.getCode().toString()).equals(entity.getDraftType())) {
				// 线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				entity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				entity.setContractStatus(ContractStatusEnum.履约中.getCode());
			} 

			if((DraftTypeEnum.线上起草.getCode().toString()).equals(entity.getDraftType()) && (null == entity.getContractFileId())) {
				// 确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
		}
		
		service.saveOrUpdate(entity);
		
		// 推送供方
		Boolean pushResult = service.pushBillToSupCenter(entity);
		if(pushResult) {
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.周转材租赁合同.getName(), billId);
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		
		// 推送合同池
		Boolean pushResult2 = service.pushContract(BeanMapper.map(entity, ContractVO.class));
		if(pushResult2) {
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		} else {
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		ContractEntity contractEntitiy = service.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureStatus()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		//将推送至供方的单据作废
		boolean pushResult = service.delPushBill(contractEntitiy);
		if (!pushResult) {
			return CommonResponse.error("弃审回调失败，单据作废协同服务失败！");
		}
		
		return CommonResponse.success("弃审/撤回前校验回调成功！");
		
	}

}
