package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("settle") 
public class SettleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private ISettleService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IRentCalculateService calculateService;
	
	@Autowired
	private IRestituteService restituteService;

	@Autowired
	private ILoseService loseService;

	@Autowired
	private IContractService contractService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		
		SettleEntity settleEntity = service.selectById(billId);

		UserContext userContext = sessionManager.getUserContext();

		LambdaUpdateWrapper<SettleEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(SettleEntity::getCommitDate, new Date());
		wrapper.set(SettleEntity::getCommitUserCode, userContext.getUserCode());
		wrapper.set(SettleEntity::getCommitUserName, userContext.getUserName());
		service.update(wrapper);
		
		if (Objects.equals(settleEntity.getSettleType(), "1")) {
			// 最终结算回写合同状态为已终止
			LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(ContractEntity::getContractStatus, ContractStatusEnum.已封账.getCode());
			updateWrapper.eq(ContractEntity::getId, settleEntity.getContractId());
			contractService.update(updateWrapper);
		}
		
		// 回写引用单据结算状态
		writeSettleFlag(settleEntity, 1);
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/

		// 结算单是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		SettleEntity entity = service.selectById(billId);

		LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.ne(SettleEntity::getId, entity.getId());
		wrapper.eq(SettleEntity::getContractId, entity.getContractId());
		wrapper.notIn(SettleEntity::getBillState, Arrays.asList(1, 3));
		wrapper.orderByDesc(SettleEntity::getCreateTime);
		List<SettleEntity> list = service.list(wrapper);
		
		if (ListUtil.isNotEmpty(list)) {
			return CommonResponse.error("当前单据存在非审批通过的单据，不能弃审！");
		}

		// 回写引用单据结算状态
		writeSettleFlag(entity, 0);
		
		return CommonResponse.success();
	}
	
	public void writeSettleFlag(SettleEntity entity, Integer settleFlag) {
		// 回写租金计算单结算状态
		List<Long> leaseIdsList = new ArrayList<>();
		List<SettleLeaseEntity> leaseList = entity.getLeaseList();
		if (ListUtil.isNotEmpty(leaseList)) {
			leaseIdsList.addAll(leaseList.stream().map(SettleLeaseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(leaseIdsList)) {
			LambdaUpdateWrapper<RentCalculateEntity> leaseWrapper = new LambdaUpdateWrapper<>();
			leaseWrapper.set(RentCalculateEntity::getSettleFlag, settleFlag);
			leaseWrapper.in(RentCalculateEntity::getId, leaseIdsList);
			calculateService.update(leaseWrapper);
		}

		// 回写退赔单、结算单 结算状态
		List<Long> restituteIdsList = new ArrayList<>();
		List<SettleRepairEntity> repairList = entity.getRepairList();
		if (ListUtil.isNotEmpty(repairList)) {
			restituteIdsList.addAll(repairList.stream().map(SettleRepairEntity::getSourceId).collect(Collectors.toList()));
		}
		List<SettleScrapEntity> scrapList = entity.getScrapList();
		if (ListUtil.isNotEmpty(scrapList)) {
			restituteIdsList.addAll(scrapList.stream().map(SettleScrapEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(restituteIdsList)) {
			LambdaUpdateWrapper<RestituteEntity> restituteWrapper = new LambdaUpdateWrapper<>();
			restituteWrapper.set(RestituteEntity::getSettleFlag, settleFlag);
			restituteWrapper.in(RestituteEntity::getId, restituteIdsList);
			restituteService.update(restituteWrapper);
		}

		// 回写遗失单结算状态
		List<SettleLoseEntity> loseList = entity.getLoseList();
		List<Long> loseIdsList = new ArrayList<>();
		if (ListUtil.isNotEmpty(loseList)) {
			loseIdsList.addAll(loseList.stream().map(SettleLoseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(loseIdsList)) {
			LambdaUpdateWrapper<LoseEntity> loseWrapper = new LambdaUpdateWrapper<>();
			loseWrapper.set(LoseEntity::getSettleFlag, settleFlag);
			loseWrapper.in(LoseEntity::getId, loseIdsList);
			loseService.update(loseWrapper);
		}
		
	}
	
}
