/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.bean.OwnEntity;
import com.ejianc.business.assist.ownrmat.mapper.ValidateMapper;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IOwnService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.utils.ListCallable;
import com.ejianc.business.assist.ownrmat.vo.AllotOutDetailVO;
import com.ejianc.business.assist.ownrmat.vo.AllotOutVO;
import com.ejianc.business.assist.ownrmat.vo.HandleDetailVO;
import com.ejianc.business.assist.ownrmat.vo.HandleVO;
import com.ejianc.business.assist.ownrmat.vo.MaxTimeVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="validateService")
public class ValidateServiceImpl
implements IValidateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String NOT_CHANGE = "\u6750\u6599\u51fa\u5e93\u660e\u7ec6\u6570\u91cf\u6ca1\u6709\u53d8\u5316,\u4ed3\u5e93\u65e0\u9700\u5904\u7406!";
    @Autowired
    private ValidateMapper baseMapper;
    @Autowired
    private IHandleService handleService;
    @Autowired
    private IAllotOutService outService;
    @Autowired
    private IOwnService ownService;
    @Autowired
    private IStoreManageApi storeManageApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateProject(Long projectId, String billType, Long billId, String type) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        QueryParam param = (QueryParam)Utils.deepCopy((Object)queryParam);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, "\u5468\u8f6c\u6750\u8c03\u51fa".equals(billType) ? param : queryParam, this.outService);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, "\u5468\u8f6c\u6750\u5904\u7f6e".equals(billType) ? param : queryParam, this.handleService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, "\u81ea\u6709\u6750\u6599\u644a\u9500".equals(billType) ? param : queryParam, this.ownService);
        List outList = new ArrayList();
        List HandleList = new ArrayList();
        List ownList = new ArrayList();
        try {
            outList = JSONObject.parseArray((String)future1.get().toJSONString(), AllotOutEntity.class);
            HandleList = JSONObject.parseArray((String)future2.get().toJSONString(), HandleEntity.class);
            ownList = JSONObject.parseArray((String)future3.get().toJSONString(), OwnEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (CollectionUtils.isNotEmpty(outList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5468\u8f6c\u6750\u8c03\u51fa\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(HandleList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u5468\u8f6c\u6750\u5904\u7f6e\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(ownList)) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u81ea\u6709\u6750\u6599\u644a\u9500\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return this.baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = this.baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Date, Date>();
        }
        return list.stream().filter(x -> x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public String validateAllotOut(AllotOutVO allotOutVO) {
        List outDetailVOList = allotOutVO.getAllotOutDetailList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outDetailVOList)) {
            for (AllotOutDetailVO allotOutDetailVO : outDetailVOList) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u51fa\u5e93, (Integer)StoreCommonConsts.NO);
                flowVO.setRowState(allotOutDetailVO.getRowState());
                flowVO.setProjectId(allotOutVO.getProjectId());
                flowVO.setProjectName(allotOutVO.getProjectName());
                flowVO.setParentOrgId(allotOutVO.getParentOrgId());
                flowVO.setParentOrgCode(allotOutVO.getParentOrgCode());
                flowVO.setParentOrgName(allotOutVO.getParentOrgName());
                flowVO.setOrgId(allotOutVO.getOrgId());
                flowVO.setOrgName(allotOutVO.getOrgName());
                flowVO.setStoreId(allotOutVO.getStoreId());
                flowVO.setStoreName(allotOutVO.getStoreName());
                flowVO.setMaterialId(allotOutDetailVO.getMaterialId());
                flowVO.setMaterialName(allotOutDetailVO.getMaterialName());
                flowVO.setMaterialCategoryId(allotOutDetailVO.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(allotOutDetailVO.getMaterialCategoryName());
                flowVO.setMaterialSpec(allotOutDetailVO.getMaterialSpec());
                flowVO.setMaterialUnitId(allotOutDetailVO.getMaterialUnitId());
                flowVO.setMaterialUnitName(allotOutDetailVO.getMaterialUnit());
                flowVO.setNum(allotOutDetailVO.getAllocatNum());
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(allotOutVO.getStoreId());
                storeManageVO.setSourceId(allotOutVO.getId());
                ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
                flowVOList.add(flowVO);
                storeManageVO.setFlowVOList(flowVOList);
                CommonResponse commonResponse = this.storeManageApi.turnSurplusMaterialPrice(storeManageVO);
                if (commonResponse.isSuccess() || NOT_CHANGE.equals(commonResponse.getMsg())) continue;
                throw new BusinessException(commonResponse.getMsg() + "\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
            }
        }
        return "\u6821\u9a8c\u6210\u529f";
    }

    @Override
    public String validateHandle(HandleVO handleVO) {
        List outDetailVOList = handleVO.getHandleSubList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(outDetailVOList)) {
            for (HandleDetailVO handleDetailVO : outDetailVOList) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)StoreCommonConsts.NO);
                flowVO.setRowState(handleDetailVO.getRowState());
                flowVO.setProjectId(handleVO.getProjectId());
                flowVO.setProjectName(handleVO.getProjectName());
                flowVO.setParentOrgId(handleVO.getParentOrgId());
                flowVO.setParentOrgCode(handleVO.getParentOrgCode());
                flowVO.setParentOrgName(handleVO.getParentOrgName());
                flowVO.setOrgId(handleVO.getOrgId());
                flowVO.setOrgName(handleVO.getOrgName());
                flowVO.setStoreId(handleVO.getStoreId());
                flowVO.setStoreName(handleVO.getStoreName());
                flowVO.setMaterialId(handleDetailVO.getMaterialId());
                flowVO.setMaterialName(handleDetailVO.getMaterialName());
                flowVO.setMaterialCategoryId(handleDetailVO.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(handleDetailVO.getMaterialCategoryName());
                flowVO.setMaterialSpec(handleDetailVO.getSpec());
                flowVO.setMaterialUnitId(handleDetailVO.getUnit());
                flowVO.setMaterialUnitName(handleDetailVO.getUnitName());
                flowVO.setNum(handleDetailVO.getHandleNum());
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(handleVO.getStoreId());
                storeManageVO.setSourceId(handleVO.getId());
                ArrayList<FlowVO> flowVOList = new ArrayList<FlowVO>();
                flowVOList.add(flowVO);
                storeManageVO.setFlowVOList(flowVOList);
                CommonResponse commonResponse = this.storeManageApi.turnSurplusMaterialPrice(storeManageVO);
                if (commonResponse.isSuccess() || NOT_CHANGE.equals(commonResponse.getMsg())) continue;
                throw new BusinessException(commonResponse.getMsg() + "\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
            }
        }
        return "\u6821\u9a8c\u6210\u529f";
    }
}

