/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractFreezeEntity;
import com.ejianc.business.assist.rmat.mapper.ContractFreezeMapper;
import com.ejianc.business.assist.rmat.service.IContractFreezeService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractFreezeVO;
import com.ejianc.business.assist.rmat.vo.record.FreezeRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractFreezeService")
public class ContractFreezeServiceImpl
extends BaseServiceImpl<ContractFreezeMapper, ContractFreezeEntity>
implements IContractFreezeService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PRORMAT_CONTRACT_FREEZE = "PRORMAT_CONTRACT_FREEZE";
    @Autowired
    private IContractService contractService;

    @Override
    public ContractFreezeVO saveOrUpdate(ContractFreezeVO saveOrUpdateVO) {
        ContractFreezeEntity entity = (ContractFreezeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractFreezeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.addFreezeFlag(saveOrUpdateVO.getContractId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRORMAT_CONTRACT_FREEZE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (ContractFreezeVO)BeanMapper.map((Object)((Object)entity), ContractFreezeVO.class);
    }

    @Override
    public Boolean addFreezeFlag(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractFreezeEntity::getContractId, (Object)id);
        wrapper.notIn(ContractFreezeEntity::getBillState, Arrays.asList(1, 3));
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u6709\u672a\u751f\u6548\u7684\u51bb\u7ed3/\u89e3\u51bb\u5355\u4e0d\u80fd\u518d\u6b21\u53d1\u8d77\u51bb\u7ed3/\u89e3\u51bb\u8bf7\u6c42\uff01");
        }
        return true;
    }

    @Override
    public FreezeRecordVO queryFreezeRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        FreezeRecordVO vo = new FreezeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractFreezeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, ContractFreezeVO.class));
        return vo;
    }
}

