package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.mapper.ContractRelieveMapper;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractRelieveVO;
import com.ejianc.business.assist.rmat.vo.record.RelieveRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 合同解除
 * 
 * @author generator
 * 
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService{

    private static final String PRORMAT_CONTRACT_RELIEVE = "PRORMAT_CONTRACT_RELIEVE";//此处需要根据实际修改

    @Autowired
    private IBillTypeApi billTypeApi;
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IContractService contractService;
    
    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveOrUpdateVO) {
        ContractRelieveEntity entity = BeanMapper.map(saveOrUpdateVO, ContractRelieveEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(PRORMAT_CONTRACT_RELIEVE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        // 查询合同状态：不是履约中不可以解除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        if (contractEntity == null || Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.已封账.getCode())
                || Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.已解除.getCode())
                ||  Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.未签订.getCode())) {
            throw new BusinessException("查询不到合同或合同状态为未签订或已封账或已解除！");
        }
        
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, entity.getContractId()));
        List<ContractRelieveEntity> list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("一个合同只能有一份合同解除协议!");
        }
        
        // 起草方式 1、上传解除协议，初始化签章状态为；1-未签章
        if (entity.getDraftType() == 1) {
            entity.setSignatureStatus(0);
        }
        
        this.saveOrUpdate(entity, false);
        
        return BeanMapper.map(entity, ContractRelieveVO.class);
    }

    @Override
    public Boolean addRelieveFlag(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
        List<ContractRelieveEntity> list = this.queryList(param);
        
        return ListUtil.isEmpty(list);
    }

    @Override
    public RelieveRecordVO queryRelieveRecord(Long id) {
        ContractEntity entity = contractService.selectById(id);
        RelieveRecordVO vo = new RelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        LambdaQueryWrapper<ContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRelieveEntity::getContractId, id);
        wrapper.orderByDesc(ContractRelieveEntity::getCreateTime);

        List<ContractRelieveEntity> list = this.list(wrapper);
        
        vo.setDetailList(BeanMapper.mapList(list, ContractRelieveVO.class));
        
        return vo;
    }
}
