package com.ejianc.business.assist.rmat.service;

import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.framework.core.response.QueryParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 材料公共接口
 * 
 * @author generator
 * 
 */
public interface IMaterialService {

    /**
     * 查询验收台账
     * @param param
     * @param type start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账
     * @return
     */
    List<MaterialVO> queryCheckList(QueryParam param, String type);

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（验收单、启用单、停用单、退赔单、遗失单、租金计算单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @param type 保存/弃审
     * @return
     */
    String validateContract(Long contractId, String billType, Long billId, String type);

    /**
     * 获取最大单据日期（验收单、启用单、停用单、退赔单、遗失单、租金计算单，只取主表单据日期，包含未生效单据）
     * @param params    contractId，billType，billId
     * @return
     */
    Date getLastDate(Map<String, Object> params);

    /**
     * 获取同一天最大制单日期（验收单、启用单、停用单、退赔单、遗失单、租金计算单，只取主表单据日期，包含未生效单据）
     * @param params    contractId，billType，billId
     * @return
     */
    Map<Date, Date> getMaxTime(Map<String, Object> params);

    List<MaterialVO> proMaterialList(QueryParam param);
}
