package com.ejianc.business.assist.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.ownrmat.vo.AmortizationVO;
import com.ejianc.business.assist.ownrmat.vo.ResidualVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.ownrmat.mapper.AmortizationMapper;
import com.ejianc.business.assist.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.assist.ownrmat.service.IAmortizationService;

import java.util.*;

/**
 * 周转材摊销设置
 *
 * @author generator
 */
@Service("amortizationService")
public class AmortizationServiceImpl extends BaseServiceImpl<AmortizationMapper, AmortizationEntity> implements IAmortizationService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Boolean saveOrUpdate(AmortizationVO saveOrUpdateVO) {
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        saveOrUpdateVO.setTenantId(tenantid);
        String orgCode = sessionManager.getUserContext().getOrgCode();
        String orgName = sessionManager.getUserContext().getOrgName();
        // 校验启用,同一组织下
        if (saveOrUpdateVO.getAmortizationStatus() == 1) {
            Integer rowType = saveOrUpdateVO.getRowType();
            LambdaQueryWrapper<AmortizationEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(AmortizationEntity::getOrgId, orgId);
            lambd.eq(AmortizationEntity::getAmortizationStatus, 1);
            lambd.eq(AmortizationEntity::getRowType, rowType);
            if (rowType == 1) {
                lambd.eq(AmortizationEntity::getMaterialTypeId, saveOrUpdateVO.getMaterialTypeId());
            } else {
                lambd.eq(AmortizationEntity::getMaterialId, saveOrUpdateVO.getMaterialId());
            }
            if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
                lambd.ne(AmortizationEntity::getId, saveOrUpdateVO.getId());
            }
            List<AmortizationEntity> list = super.list(lambd);
            if (CollectionUtils.isNotEmpty(list)) {
                if (rowType == 1) {
                    throw new BusinessException(saveOrUpdateVO.getMaterialTypeName() + "(材料分类)已有启用设置，请关闭后再添加启用设置。");
                } else {
                    throw new BusinessException(saveOrUpdateVO.getMaterialName() + "(材料)已有启用设置，请关闭后再添加启用设置。");
                }

            }
        }
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() <= 0) { //新增
            saveOrUpdateVO.setOrgId(orgId);
            saveOrUpdateVO.setOrgCode(orgCode);
            saveOrUpdateVO.setOrgName(orgName);
        }
        AmortizationEntity entity = BeanMapper.map(saveOrUpdateVO, AmortizationEntity.class);
        return super.saveOrUpdate(entity, false);
    }

    @Override
    public String turnSwitch(AmortizationVO vo) {
        if (vo.getAmortizationStatus() == 0) {
            LambdaUpdateWrapper<AmortizationEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(AmortizationEntity::getAmortizationStatus, 0);
            lambd.eq(AmortizationEntity::getId, vo.getId());
            super.update(lambd);
            return "停用成功！";
        } else {
            // 先停用已启用的
            Integer rowType = vo.getRowType();
            LambdaUpdateWrapper<AmortizationEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(AmortizationEntity::getAmortizationStatus, 0);
            lambd.eq(AmortizationEntity::getAmortizationStatus, 1);
            lambd.eq(AmortizationEntity::getOrgId, vo.getOrgId());
            if (rowType == 1) {
                lambd.eq(AmortizationEntity::getMaterialTypeId, vo.getMaterialTypeId());
            } else {
                lambd.eq(AmortizationEntity::getMaterialId, vo.getMaterialId());
            }
            lambd.ne(AmortizationEntity::getId, vo.getId());
            super.update(lambd);

            // 启用
            LambdaUpdateWrapper<AmortizationEntity> lambdUpdate = new LambdaUpdateWrapper<>();
            lambdUpdate.set(AmortizationEntity::getAmortizationStatus, 1);
            lambdUpdate.eq(AmortizationEntity::getId, vo.getId());
            super.update(lambdUpdate);
            return "启用成功！";
        }
    }

    @Override
    public Map<Long, AmortizationEntity> getResidualRate(ResidualVO vo) {
        Map<Long, AmortizationEntity> rateMap = getResidualRateByOrgId(vo);
        return rateMap;
    }

    private Map<Long, AmortizationEntity> getResidualRateByOrgId(ResidualVO vo) {
        Long orgId = vo.getOrgId();
        List<Long> materialIds = vo.getMaterialIds();
        if (CollectionUtils.isEmpty(materialIds)) {
            return new HashMap<>();
        }

        LambdaQueryWrapper<AmortizationEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(AmortizationEntity::getOrgId, orgId);
        lambd.eq(AmortizationEntity::getAmortizationStatus, 1);
        List<AmortizationEntity> list = super.list(lambd);// 包含材料和分类

        Map<Long, AmortizationEntity> map = new HashMap<>();

        List<AmortizationEntity> typeList = new ArrayList<>(); // 只有材料分类

        for (AmortizationEntity entity : list) {
            if (entity.getRowType() == 2 && materialIds.size() > 0) {
                if (materialIds.contains(entity.getMaterialId())) {
                    map.put(entity.getMaterialId(), entity);
                    materialIds.remove(entity.getMaterialId());
                }
            } else {
                typeList.add(entity);
            }
        }
        if (materialIds.size() == 0) {
            // 已经全部查出
            return map;
        } else {
            if (CollectionUtils.isEmpty(typeList)) {
                // 没有分类，查上级组织
                OrgVO parentsVo = orgApi.detailById(orgId).getData();
                if(parentsVo.getParentId() != null && parentsVo.getParentId() > 0){
                    ResidualVO residualVO = new ResidualVO();
                    residualVO.setOrgId(parentsVo.getParentId());
                    residualVO.setMaterialIds(materialIds);
                    Map<Long, AmortizationEntity> resMap = getResidualRateByOrgId(residualVO);
                    map.putAll(resMap);
                }

                return map;
            } else {
                // 先查上级分类
                CommonResponse<Map<Long, List<MaterialCategoryVO>>> mapCommonResponse = shareMaterialApi.queryCategoryListByMaterialId(materialIds);
                if (!mapCommonResponse.isSuccess()) {
                    throw new BusinessException("查询材料上级分类失败");
                }
                Map<Long, List<MaterialCategoryVO>> dataMap = mapCommonResponse.getData();
                Map<Long, AmortizationEntity> residualRateMap = getResidualRateByCategory(typeList, dataMap);
                map.putAll(residualRateMap);
                if (residualRateMap.size() != materialIds.size()) {
                    // 剩下的查上级组织
                    OrgVO parentsVo = orgApi.detailById(orgId).getData();
                    if(parentsVo.getParentId() != null && parentsVo.getParentId() > 0){
                        ResidualVO residualVO = new ResidualVO();
                        residualVO.setOrgId(parentsVo.getParentId());
                        List<Long> matIds = BeanMapper.mapList(materialIds, Long.class);
                        for (Long mid : residualRateMap.keySet()) {
                            if (matIds.contains(mid)) {
                                matIds.remove(mid);
                            }
                        }
                        residualVO.setMaterialIds(matIds);
                        Map<Long, AmortizationEntity> resMap = getResidualRateByOrgId(residualVO);
                        map.putAll(resMap);
                    }
                    return map;
                } else {
                    return map;
                }
            }
        }
    }

    private Map<Long, AmortizationEntity> getResidualRateByCategory(List<AmortizationEntity> typeList, Map<Long, List<MaterialCategoryVO>> dataMap) {
        Map<Long, AmortizationEntity> resMap = new HashMap<>();
        Map<Long, AmortizationEntity> typeMap = new HashMap<>();
        for (AmortizationEntity entity : typeList) {
            typeMap.put(entity.getMaterialTypeId(), entity);
        }
        for (Long materialId : dataMap.keySet()) {
            List<MaterialCategoryVO> materialCategoryVOS = dataMap.get(materialId);
            for (MaterialCategoryVO vo : materialCategoryVOS) {
                if (typeMap.containsKey(vo.getId())) {
                    resMap.put(materialId, typeMap.get(vo.getId()));
                    break;
                }
            }
        }
        return resMap;
    }
}
