package com.ejianc.business.assist.rmat.service.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.common.util.MathUtil;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.mapper.DeliveryDetailMapper;
import com.ejianc.business.assist.rmat.mapper.DeliveryMapper;
import com.ejianc.business.assist.rmat.service.IDeliveryService;
import com.ejianc.business.assist.rmat.service.IOrderDetailService;
import com.ejianc.business.assist.rmat.service.IOrderService;
import com.ejianc.business.assist.rmat.utils.EntityUtil;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材租赁-送货单
 * 
 * @author generator
 * 
 */
@Service("deliveryService")
public class DeliveryServiceImpl extends BaseServiceImpl<DeliveryMapper, DeliveryEntity> implements IDeliveryService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 无权访问 */
    private static final String noPower = "无权限访问该服务，请先联系管理员进行授权！";

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private IAttachmentApi attachmentApi;


    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private DeliveryDetailMapper detailMapper;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private PushSupUtil pushSupUtil;

    private static final String OPERATE = "supDeliveryBill";


    private static final String BILL_CODE = "BT220223000000005";

    private static final String BILL_NAME = "送货单";

    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/delivery/supSignSync";

    private static final String CHANGE_CLOSE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/delivery/changeCloseState";

    @Override
    public String  saveSyncBill(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> map = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到推送单据-{}: {}, 当前上下文: {}", BILL_NAME, transData, authority);
        if(StringUtils.isBlank(transData)) {
            return "单据同步失败，单据内容为空！";
        }
        DeliveryEntity entity = JSONObject.parseObject(transData, DeliveryEntity.class);
        entity.setSourceId(entity.getId().toString());
        this.clearInvalidData(entity);

        DeliveryEntity data = EntityUtil.selectOne("source_id", entity.getSourceId(), DeliveryEntity.class);
        if(null != data) {
            return "单据已经进行过同步操作，请勿重复操作！";
        }

        List<Long> attchIdsList = new ArrayList<>();
        if (request instanceof MultipartHttpServletRequest){
            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    map, BILL_CODE, authority, null);
            for(List<Long> attachIds : attachIdsMap.values()) {
                if(CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
        }
        //将附件关联在单据中
        entity.setAttachIds(attchIdsList);

        this.submitChangeDeliveryNums(entity.getDeliveryDetailList());
        this.submitChangeDeliveryState(entity.getOrderId(),entity.getDeliveryDetailList());
        super.saveOrUpdate(entity, false);

        //向单据制单人和经办人推送该消息
        String[] channel = new String[]{PushMsgParameter.CHANNEL_TYPE_SYS};

        String linkId = entity.getLinkId().toString();
        String[] receivers = new String[]{linkId};
        String result = pushSupUtil.sendMsg(channel, receivers, "notice","订单开始送货提醒", BILL_NAME + "[" + BILL_CODE + "]订单开始送货");
        if (null != result) {
            logger.error("向用户-{}发送单据id-{}送货单推送失败，原因：{}", StringUtils.join(receivers), entity.getId(), result);
        }

        return null;
    }

    private void clearInvalidData(DeliveryEntity entity) {
        entity.setCreateTime(null);
//        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        entity.setUpdateTime(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
//        entity.setCommitUserCode(null);
        entity.setUpdateUserCode(null);
    }

    @Override
    public String updateBillConfirmState(DeliveryEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_CODE + "::" + entity.getId().toString() + "::sup";

        CommonResponse<UserVO> userResp = userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(!userResp.isSuccess()) {
            logger.error("查询当前用户id-{},信息失败， {}", InvocationInfoProxy.getUserid(), userResp.getMsg());
            return "查询当前用户信息失败!";
        }
        UserVO user = userResp.getData();

        //查询当前用户信息
        logger.info("用户{}对单据id-{}进行确认操作！", user.getUserName(), entity.getId());

        //将当前操作人信息记录在单据中
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());

        try {
            //对单据进行加锁
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if(!locked) {//加锁失败
                releaseLock(jedis, false, key, OPERATE);
                return "单据已被修改，请勿重复操作！";
            }

            Map<String, Map<String, InputStream>> files = new HashMap<>();

            // 回写参数
            Map<String, String> params = new HashMap<>();
            params.put("billId", entity.getId().toString());
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("acceptanceState", entity.getAcceptanceState());


            //回写单据签字状态
            logger.info("单据-{}id-{}已确认，通知单据推送方systemId-{},参数-{}", BILL_NAME, entity.getId(), entity.getSourceSystemId(), JSONObject.toJSONString(params));
            CommonResponse<String> backResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), files);
            logger.error("单据-{}签字信息回写发送请求结果，{}", BILL_NAME, JSONObject.toJSONString(backResp));
            if(!backResp.isSuccess()) {
                logger.error("单据-{}id-{}确认信息回写发送请求失败，{}", BILL_NAME, entity.getId(), backResp.getMsg());
                return BILL_NAME + "确认信息回写发送请求失败";
            }

            CommonResponse<String> operateResp = JSONObject.parseObject(backResp.getData(), CommonResponse.class);
            if(!operateResp.isSuccess()) {
                logger.error("单据-{}id-{}确认信息回调处理失败，{}", BILL_NAME, entity.getId(), operateResp.getMsg());
                return "确认信息回调处理失败";
            }

            //更新单据
            super.saveOrUpdate(entity);

        } catch (Exception e) {
            logger.error("单据-{}id-{}确认异常，", BILL_NAME, entity.getId(), e);
            msg = "操作失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }




    @Override
    public String billDel(DeliveryEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_CODE + "::" + entity.getId().toString() + "::sup";
        try {
            //对单据进行加锁
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if(!locked) {//加锁失败
                releaseLock(jedis, false, key, OPERATE);
                return  "单据作废失败，单据数据已被修改！";
            }
            //查询单据附件信息
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
            if(!fileResp.isSuccess()) {
                return "单据作废失败，获取单据附件失败！";
            }
            //删除单据附件信息
            List<AttachmentVO> files = fileResp.getData();
            if(CollectionUtils.isNotEmpty(files)) {
                CommonResponse<String> fileDelResp = attachmentApi.delete(StringUtils.join(
                        files.stream().map(file -> file.getId()).collect(Collectors.toList()), ","));
                if(!fileDelResp.isSuccess()) {
                    return  "单据作废失败，单据附件删除失败！";
                }
            }

            this.backChangeDeliveryNums(entity.getDeliveryDetailList());
            this.backChangeDeliveryState(entity.getOrderId(),entity.getDeliveryDetailList());
            //删除单据
            boolean delResult  = this.delById(entity.getId());
            if(!delResult) {
                return "操作失败，单据删除失败！";
            }
        } catch (Exception e) {
            logger.error("单据-{}id-{}作废失败，", BILL_NAME, entity.getId(), e);
            msg = "操作失败，单据信息处理异常！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }


    @Transactional(rollbackFor = Exception.class)
    public boolean delById(Long id) {
        baseMapper.delById(id);
        detailMapper.delByTId(id);
        return true;
    }

    private void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }


    @Override
    public void submitChangeDeliveryNums(List<DeliveryDetailEntity> deliveryDetailList){
        for (DeliveryDetailEntity detailEntity:deliveryDetailList){
            OrderDetailEntity orderDetailEntity = orderDetailService.selectById(detailEntity.getOrderDetailId());
            BigDecimal notDeliveredNumsSum = MathUtil.safeSub(orderDetailEntity.getNotDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            BigDecimal deliveredNumsSum = MathUtil.safeAdd(orderDetailEntity.getDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            LambdaUpdateWrapper<OrderDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderDetailEntity::getId,detailEntity.getOrderDetailId());
            wrapper.set(OrderDetailEntity::getNotDeliveredNumsSum,notDeliveredNumsSum);
            wrapper.set(OrderDetailEntity::getDeliveredNumsSum,deliveredNumsSum);
            orderDetailService.update(wrapper);
        }
    }

    @Override
    public void backChangeDeliveryNums(List<DeliveryDetailEntity> deliveryDetailList){
        for (DeliveryDetailEntity detailEntity:deliveryDetailList){
            OrderDetailEntity orderDetailEntity = orderDetailService.selectById(detailEntity.getOrderDetailId());
            BigDecimal notDeliveredNumsSum = MathUtil.safeAdd(orderDetailEntity.getNotDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            BigDecimal deliveredNumsSum = MathUtil.safeSub(orderDetailEntity.getDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            LambdaUpdateWrapper<OrderDetailEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderDetailEntity::getId,detailEntity.getOrderDetailId());
            wrapper.set(OrderDetailEntity::getNotDeliveredNumsSum,notDeliveredNumsSum);
            wrapper.set(OrderDetailEntity::getDeliveredNumsSum,deliveredNumsSum);
            orderDetailService.update(wrapper);
        }
    }

    @Override
    public void submitChangeDeliveryState(Long orderId,List<DeliveryDetailEntity> detailEntities){
        Map<Long, DeliveryDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(DeliveryDetailEntity::getOrderDetailId, Function.identity(), (k1, k2) -> k2));
        OrderEntity orderEntity = orderService.selectById(orderId);
        Boolean allDelivery = true;
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()){
            BigDecimal deliveredNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(orderDetailEntity.getId())){
                DeliveryDetailEntity detailEntity = collect.get(orderDetailEntity.getId());
                deliveredNumsSum = MathUtil.safeAdd(orderDetailEntity.getDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            }else{
                deliveredNumsSum = orderDetailEntity.getDeliveredNumsSum();
            }
            if (null==deliveredNumsSum||deliveredNumsSum.compareTo(orderDetailEntity.getReceiveNumsSum()) == -1){
                allDelivery = false;
            }
        }
        if (allDelivery){
            LambdaUpdateWrapper<OrderEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderEntity::getId,orderId);
            wrapper.set(OrderEntity::getDeliverState, CommonConstant.ORDER_DELIVER_ALL);
            orderService.update(wrapper);
        }else{
            LambdaUpdateWrapper<OrderEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderEntity::getId,orderId);
            wrapper.set(OrderEntity::getDeliverState, CommonConstant.ORDER_DELIVER_PART);
            orderService.update(wrapper);
        }
    }

    @Override
    public void backChangeDeliveryState(Long orderId,List<DeliveryDetailEntity> detailEntities){
        Map<Long, DeliveryDetailEntity> collect = detailEntities.stream().collect(Collectors.toMap(DeliveryDetailEntity::getOrderDetailId, Function.identity(), (k1, k2) -> k2));
        OrderEntity orderEntity = orderService.selectById(orderId);
        Boolean waitDelivery = true;
        for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()){
            BigDecimal deliveredNumsSum = BigDecimal.ZERO;
            if (null!=collect.get(orderDetailEntity.getId())){
                DeliveryDetailEntity detailEntity = collect.get(orderDetailEntity.getId());
                deliveredNumsSum = MathUtil.safeSub(orderDetailEntity.getDeliveredNumsSum(),detailEntity.getDeliveredNumsSum());
            }else{
                deliveredNumsSum = orderDetailEntity.getDeliveredNumsSum();
            }
            if (null==deliveredNumsSum||deliveredNumsSum.compareTo(BigDecimal.ZERO) == 1){
                waitDelivery = false;
            }
        }
        if (waitDelivery){
            LambdaUpdateWrapper<OrderEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderEntity::getId,orderId);
            wrapper.set(OrderEntity::getDeliverState, CommonConstant.ORDER_DELIVER_WAIT);
            orderService.update(wrapper);
        }else{
            LambdaUpdateWrapper<OrderEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(OrderEntity::getId,orderId);
            wrapper.set(OrderEntity::getDeliverState, CommonConstant.ORDER_DELIVER_PART);
            orderService.update(wrapper);
        }
    }


    @Override
    public String changeCloseState(DeliveryEntity entity){

        String msg = null;
        Jedis jedis = null;
        boolean locked = false;

        String key = BILL_CODE + "::" + entity.getId().toString() + "::sup";

        try {
            //对单据进行加锁
            jedis = jedisPool.getResource();
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);
            if(!locked) {//加锁失败
                releaseLock(jedis, false, key, OPERATE);
                return "单据已被修改，请勿重复操作！";
            }
            // 回写参数
            Map<String, String> params = new HashMap<>();
            params.put("billId", entity.getId().toString());


            Map<String, Map<String, InputStream>> files = new HashMap<>();

            logger.info("参数-{}，供方-{}",JSONObject.toJSONString(params),entity.getSupplierId().toString());
            CommonResponse<String> backResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(CHANGE_CLOSE_BILL_SERVER_URL,params, entity.getSupplierId().toString(),files);

            logger.error("单据-{}发送请求结果，{}", BILL_NAME, JSONObject.toJSONString(backResp));
            if(!backResp.isSuccess()) {
                return BILL_NAME + "校验关闭发送请求失败";
            }

            if(noPower.equals(backResp.getData())){
                logger.error("发送请求URL-{}给供应商-{}失败, {}", CHANGE_CLOSE_BILL_SERVER_URL, entity.getSupplierId(), backResp.getData());
                return backResp.getData();
            }

            LambdaUpdateWrapper<DeliveryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(DeliveryEntity::getId,entity.getId());
            updateWrapper.set(DeliveryEntity::getDisableState,CommonConstant.ORDER_DISABLE_YES);
            super.update(updateWrapper);

        } catch (Exception e) {
            msg = "操作失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

}
