/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.business.assist.rmat.vo.LoseVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.assist.rmat.vo.record.SettleRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"settle"})
public class SettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveOrUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(id));
        SettleVO vo = (SettleVO)BeanMapper.map((Object)((Object)entity), SettleVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO settleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Parameter settleDate = (Parameter)param.getParams().get("settleDate");
        if (!Objects.equals(settleDate, null)) {
            String value = settleDate.getValue().toString();
            String[] split = value.split(",");
            String startSetlleDate = split[0] + " 00:00:00";
            String endSetlleDate = split[1] + " 23:59:59";
            param.getParams().remove("settleDate");
            param.getParams().put("settleDate", new Parameter("between", (Object)(startSetlleDate + "," + endSetlleDate)));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, SettleVO.class);
        for (SettleVO vo : voList) {
            if (vo.getSupplierSignStatus().equals(0)) {
                vo.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            } else if (vo.getSupplierSignStatus().equals(1)) {
                vo.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                vo.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("settle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/queryRestituteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RestituteVO>> queryRestituteData(@RequestParam(value="contractId") Long contractId, @RequestParam(value="lastSettleDate", required=false) String lastSettleDate, @RequestParam(value="settleDate", required=false) String settleDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9000\u8d54\u5355\u6210\u529f\uff01", this.service.queryRestituteData(contractId, lastSettleDate, settleDate));
    }

    @RequestMapping(value={"/queryLoseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<LoseVO>> queryLoseData(@RequestParam(value="contractId") Long contractId, @RequestParam(value="lastSettleDate", required=false) String lastSettleDate, @RequestParam(value="settleDate", required=false) String settleDate) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9057\u5931\u5355\u6210\u529f\uff01", this.service.queryLoseData(contractId, lastSettleDate, settleDate));
    }

    @RequestMapping(value={"/queryLastSettleTaxMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleVO> queryLastSettleTaxMny(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u9057\u5931\u5355\u6210\u529f\uff01", (Object)this.service.queryLastSettleTaxMny(contractId, billId));
    }

    @RequestMapping(value={"/querySettleRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleRecordVO> querySettleRecord(@RequestParam Long id) {
        SettleRecordVO vo = this.service.querySettleRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

