package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.IRelieveSignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @author baipengyan
 */
@Service("relieveSignatureService")
public class RelieveSignatureServiceImpl implements IRelieveSignatureService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IContractRelieveService service;

    @Autowired
    private IContractService contractService;

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param id              合同解除单据id
     * @param signatureStatus 签章状态
     * @param refCode         唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(Long id, Integer signatureStatus, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参--id；{}，signatureStatus：{}，refCode：{}", id, signatureStatus, refCode);
        
        // signatureStatus - 1 是因为分包的签章状态是1234，签章服务传递的参数也是固定的1234，但这边是0123，需要-1
        signatureStatus = signatureStatus - 1;

        // 判断是否是合同解除标识
        if (refCode.equals("prormat_contract_relieve")) {
            ContractRelieveEntity contractRelieveEntity = service.selectById(id);
            contractRelieveEntity.setSignatureStatus(Integer.valueOf(signatureStatus));

            // 查询合同的信息
            ContractEntity contractEntity = contractService.selectById(contractRelieveEntity.getContractId());
            if (contractEntity == null) {
                throw new BusinessException("查询不到可修改状态的合同！");
            }
            logger.info("即将修改的合同信息--{}", JSONObject.toJSONString(contractEntity));
            // 签章状态：4-已签章，履约中允许解除（冻结及其他状态不能解除）
            if (SignatureStatusEnum.已签章.getCode().equals(signatureStatus) && ContractStatusEnum.履约中.getCode().equals(contractEntity.getContractStatus())) {
                // 更新合同解除单据生效时间
                contractRelieveEntity.setEffectiveDate(new Date());
                // 更新合同状态为已解除
                contractEntity.setContractStatus(ContractStatusEnum.已解除.getCode());
                contractService.saveOrUpdate(contractEntity, false);
                logger.info("合同已解除！");
            }
            service.saveOrUpdate(contractRelieveEntity, false);
            return CommonResponse.success("合同解除单据签章状态更新成功！");
        } else {
            return CommonResponse.error("合同解除单据签章状态更新失败！");
        }
    }
}
