/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.assist.rmat.bean.ChangeDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ChangeMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ChangeNumRentEntity;
import com.ejianc.business.assist.rmat.bean.ChangeOtherEntity;
import com.ejianc.business.assist.rmat.bean.ChangePaymentEntity;
import com.ejianc.business.assist.rmat.bean.ChangeRepairEntity;
import com.ejianc.business.assist.rmat.bean.ChangeScrapEntity;
import com.ejianc.business.assist.rmat.bean.ContractClauseEntity;
import com.ejianc.business.assist.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractOtherEntity;
import com.ejianc.business.assist.rmat.bean.ContractPaymentEntity;
import com.ejianc.business.assist.rmat.bean.ContractRepairEntity;
import com.ejianc.business.assist.rmat.bean.ContractScrapEntity;
import com.ejianc.business.assist.rmat.bean.RecordClauseEntity;
import com.ejianc.business.assist.rmat.bean.RecordDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.RecordEntity;
import com.ejianc.business.assist.rmat.bean.RecordMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.RecordNumRentEntity;
import com.ejianc.business.assist.rmat.bean.RecordOtherEntity;
import com.ejianc.business.assist.rmat.bean.RecordPaymentEntity;
import com.ejianc.business.assist.rmat.bean.RecordRepairEntity;
import com.ejianc.business.assist.rmat.bean.RecordScrapEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.mapper.ChangeMapper;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractClauseService;
import com.ejianc.business.assist.rmat.service.IContractDailyRentService;
import com.ejianc.business.assist.rmat.service.IContractMonthRentService;
import com.ejianc.business.assist.rmat.service.IContractNumRentService;
import com.ejianc.business.assist.rmat.service.IContractOtherService;
import com.ejianc.business.assist.rmat.service.IContractPaymentService;
import com.ejianc.business.assist.rmat.service.IContractRepairService;
import com.ejianc.business.assist.rmat.service.IContractScrapService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.IRecordService;
import com.ejianc.business.assist.rmat.vo.ChangeClauseVO;
import com.ejianc.business.assist.rmat.vo.ChangeCompareVO;
import com.ejianc.business.assist.rmat.vo.ChangeDailyRentVO;
import com.ejianc.business.assist.rmat.vo.ChangeMonthRentVO;
import com.ejianc.business.assist.rmat.vo.ChangeNumRentVO;
import com.ejianc.business.assist.rmat.vo.ChangeOtherVO;
import com.ejianc.business.assist.rmat.vo.ChangePaymentVO;
import com.ejianc.business.assist.rmat.vo.ChangeRepairVO;
import com.ejianc.business.assist.rmat.vo.ChangeScrapVO;
import com.ejianc.business.assist.rmat.vo.ChangeVO;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.ChangeRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT_CNAHGE";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IRecordService recordService;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractDailyRentService dailyRentService;
    @Autowired
    private IContractMonthRentService monthRentService;
    @Autowired
    private IContractNumRentService numRentService;
    @Autowired
    private IContractRepairService repairService;
    @Autowired
    private IContractScrapService scrapService;
    @Autowired
    private IContractOtherService otherService;
    @Autowired
    private IContractPaymentService paymentService;
    @Autowired
    private IContractClauseService clauseService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public ChangeVO saveOrUpdate(ChangeVO saveOrUpdateVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(saveOrUpdateVO.getMainContractId()));
        if (ListUtil.isNotEmpty((List)saveOrUpdateVO.getAttachIds()) && null != contractEntity.getContractFileId()) {
            saveOrUpdateVO.getAttachIds().remove(contractEntity.getContractFileId());
        }
        ChangeEntity entity = (ChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, (Object)saveOrUpdateVO.getMainContractId());
        if (saveOrUpdateVO.getId() != null) {
            lambdachange.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            this.clearDetailList(entity);
            this.deleteOldCost((ChangeVO)BeanMapper.map((Object)((Object)contractEntity), ChangeVO.class));
        }
        entity.setContractId(entity.getMainContractId());
        entity.setBeforeContractName(entity.getMainContractName());
        entity.setChangeContractName(entity.getContractName());
        this.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(ContractEntity::getChangingMny, (Object)entity.getContractMny());
        updateWrapper.set(ContractEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)entity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, (Object)entity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeDraftType, (Object)entity.getChangeDraftType());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)entity.getSignatureStatus());
        updateWrapper.set(ContractEntity::getChangeFileId, (Object)entity.getChangeFileId());
        updateWrapper.set(ContractEntity::getChangeContractName, (Object)entity.getContractName());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getMainContractId());
        this.contractService.update((Wrapper)updateWrapper);
        ChangeVO vo = (ChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), ChangeVO.class);
        CommonResponse response = this.executionApi.aggPush(this.targetCost(vo));
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25\uff01");
        }
        return (ChangeVO)BeanMapper.map((Object)((Object)entity), ChangeVO.class);
    }

    @Override
    public ChangeRecordVO queryChangeRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeRecordVO vo = new ChangeRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setBaseMny(entity.getBaseMny());
        vo.setBaseTaxMny(entity.getBaseTaxMny());
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ChangeEntity::getContractId, (Object)id);
        wrapper.orderByDesc(ChangeEntity::getSignDate);
        List changeList = super.list((Wrapper)wrapper);
        vo.setTotalChangeMny(ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getBaseTaxMny()));
        vo.setTotalChangeNum(Integer.valueOf(changeList.size()));
        vo.setTotalChangeRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalChangeMny(), (BigDecimal)vo.getBaseTaxMny()), (BigDecimal)new BigDecimal("100")));
        vo.setDetailList(BeanMapper.mapList((Iterable)changeList, ChangeVO.class));
        return vo;
    }

    @Override
    public ChangeVO queryContractRecordDetail(Long id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RecordEntity::getChangeId, (Object)id);
        List list = this.recordService.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return (ChangeVO)BeanMapper.map((Object)this.recordService.selectById(((RecordEntity)((Object)list.get(0))).getId()), ChangeVO.class);
        }
        return new ChangeVO();
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.selectById(changeBillId));
        ContractVO contractVO = this.contractService.queryDetail(changeEntity.getContractId());
        this.writeBackRecord(changeEntity, contractVO);
        this.writeBackContract(changeEntity, contractVO);
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setContractStatus(ContractStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setCommitDate(new Date());
        this.changeService.saveOrUpdate((Object)changeEntity);
        return CommonResponse.success((String)"\u53d8\u66f4\u5355\u751f\u6548\uff0c\u56de\u5199\u5408\u540c\u6210\u529f\uff01");
    }

    @Override
    public void deleteByIds(List<ChangeVO> vos) {
        for (ChangeVO vo : vos) {
            ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            this.deleteOldCost((ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class));
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(ChangeEntity::getContractId, (Object)changeEntity.getContractId());
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List list = this.list((Wrapper)wrapper);
            ChangeVO changeVO = new ChangeVO();
            if (ListUtil.isNotEmpty((List)list)) {
                changeVO = (ChangeVO)BeanMapper.map(list.get(0), changeVO.getClass());
            } else {
                ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
                changeVO = (ChangeVO)BeanMapper.map((Object)((Object)contractEntity), changeVO.getClass());
            }
            this.targetCost(changeVO);
            LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
            if (changeEntity.getChangeVersion() == 1) {
                lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)1);
            } else {
                lambdaUpdate.set(ContractEntity::getChangeStatus, (Object)3);
            }
            lambdaUpdate.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            this.contractService.update((Wrapper)lambdaUpdate);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.selectById(id));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(RecordEntity::getChangeId, (Object)id);
            wrapper.eq(RecordEntity::getContractId, (Object)changeEntity.getContractId());
            wrapper.orderByDesc(BaseEntity::getCreateTime);
            List recordEntityList = this.recordService.list((Wrapper)wrapper);
            if (ListUtil.isNotEmpty((List)recordEntityList)) {
                beforeChangeVO = (ChangeCompareVO)BeanMapper.map(recordEntityList.get(0), changeCompareVO.getClass());
            }
        } else {
            beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ChangeDailyRentVO beforeVO;
            if (ListUtil.isNotEmpty((List)changeCompareVO.getDailyRentList())) {
                List dailyRentList = beforeChangeVO.getDailyRentList();
                Map beforeDailyMap = dailyRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getDailyRentList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeDailyRentVO)beforeDailyMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setDailyRentList(changeCompareVO.getDailyRentList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getMonthRentList())) {
                List monthRentList = beforeChangeVO.getMonthRentList();
                Map beforeMonthMap = monthRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getMonthRentList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeMonthRentVO)beforeMonthMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLackMonthDayUnitTaxPrice(beforeVO.getBcLackMonthDayUnitTaxPrice());
                    vo.setBcStopUnitTaxPrice(beforeVO.getStopUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setMonthRentList(changeCompareVO.getMonthRentList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getNumRentList())) {
                List numRentList = beforeChangeVO.getNumRentList();
                Map beforeNumMap = numRentList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getNumRentList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeNumRentVO)beforeNumMap.get(vo.getSourceBid());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(beforeVO.getUnitTaxPrice());
                    vo.setBcLoseUnitTaxPrice(beforeVO.getLoseUnitTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcStartDate(beforeVO.getStartDate());
                    vo.setBcEndDate(beforeVO.getEndDate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setNumRentList(changeCompareVO.getNumRentList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getRepairList())) {
                List repairList = beforeChangeVO.getRepairList();
                Map beforeRepairMap = repairList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getRepairList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeRepairVO)beforeRepairMap.get(vo.getSourceBid());
                    vo.setBcRepairItemName(beforeVO.getRepairItemName());
                    vo.setBcRepairUnitName(beforeVO.getRepairUnitName());
                    vo.setBcRepairTaxPrice(beforeVO.getRepairTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setRepairList(changeCompareVO.getRepairList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getScrapList())) {
                List scrapList = beforeChangeVO.getScrapList();
                Map beforeScrapMap = scrapList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getScrapList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeScrapVO)beforeScrapMap.get(vo.getSourceBid());
                    vo.setBcDamageScrapName(beforeVO.getDamageScrapName());
                    vo.setBcDamageScrapUnitName(beforeVO.getDamageScrapUnitName());
                    vo.setBcDamageScrapTaxPrice(beforeVO.getDamageScrapTaxPrice());
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setScrapList(changeCompareVO.getScrapList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            if (ListUtil.isNotEmpty((List)changeCompareVO.getOtherList())) {
                List otherList = beforeChangeVO.getOtherList();
                Map beforeOtherMap = otherList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                for (ChangeDailyRentVO vo : changeCompareVO.getOtherList()) {
                    if (vo.getChangeType() == null || vo.getChangeType().equals("\u65b0\u589e\u9879")) continue;
                    beforeVO = (ChangeOtherVO)beforeOtherMap.get(vo.getSourceBid());
                    vo.setBcCostName(beforeVO.getCostName());
                    vo.setBcCount(beforeVO.getCount());
                    vo.setBcUnitTaxPrice(BigDecimal.ZERO);
                    vo.setBcTaxRate(beforeVO.getTaxRate());
                    vo.setBcMemo(beforeVO.getMemo());
                }
                changeCompareVO.setOtherList(changeCompareVO.getOtherList().stream().filter(daily -> daily.getChangeType() != null).collect(Collectors.toList()));
            }
            ArrayList newClauses = new ArrayList();
            Map<Long, ChangeClauseVO> beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getSourceId, clause -> clause, (v1, v2) -> v2));
            if (ListUtil.isNotEmpty((List)changeCompareVO.getClauseList())) {
                changeCompareVO.getClauseList().stream().forEach(clause -> {
                    if (clause.getSourceId() == null) {
                        clause.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                    } else if (beforeClauseMap.containsKey(clause.getSourceId())) {
                        if (!((ChangeClauseVO)beforeClauseMap.get(clause.getSourceId())).getClauseContent().equals(clause.getClauseContent())) {
                            clause.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                            newClauses.add(clause);
                        }
                        beforeClauseMap.remove(clause.getSourceId());
                    }
                });
            }
            if (MapUtils.isNotEmpty(beforeClauseMap)) {
                beforeClauseMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newClauses.add(c);
                });
            }
            changeCompareVO.setClauseList(newClauses);
            ArrayList<ChangePaymentVO> newPayList = new ArrayList<ChangePaymentVO>();
            Map<Long, ChangePaymentVO> beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getSourceId, item -> item, (v1, v2) -> v2));
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getClauseList())) {
                ChangePaymentVO beforeItem = null;
                for (ChangePaymentVO curItem : changeCompareVO.getPaymentList()) {
                    if (curItem.getSourceId() == null) {
                        curItem.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD.toString());
                        continue;
                    }
                    if (!beforeClauseMap.containsKey(curItem.getSourceId())) continue;
                    beforeItem = beforePayMap.get(curItem.getSourceId());
                    if (!beforeItem.getPaymentName().equals(curItem.getPaymentName()) || !beforeItem.getPaymentScale().equals(curItem.getPaymentScale())) {
                        curItem.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE.toString());
                        newPayList.add(curItem);
                    }
                    beforeClauseMap.remove(curItem.getSourceId());
                }
            }
            if (MapUtils.isNotEmpty(beforePayMap)) {
                beforePayMap.values().forEach(c -> {
                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL.toString());
                    newPayList.add((ChangePaymentVO)c);
                });
            }
            changeCompareVO.setPaymentList(newPayList);
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    public void writeBackRecord(ChangeEntity changeEntity, ContractVO contractVO) {
        RecordEntity recordEntity = (RecordEntity)((Object)BeanMapper.map((Object)contractVO, RecordEntity.class));
        recordEntity.setContractId(changeEntity.getContractId());
        recordEntity.setId(null);
        if (ListUtil.isNotEmpty(recordEntity.getDailyRentList())) {
            for (RecordDailyRentEntity recordDailyRentEntity : recordEntity.getDailyRentList()) {
                recordDailyRentEntity.setSourceBid(recordDailyRentEntity.getId());
                recordDailyRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getMonthRentList())) {
            for (RecordMonthRentEntity recordMonthRentEntity : recordEntity.getMonthRentList()) {
                recordMonthRentEntity.setSourceBid(recordMonthRentEntity.getId());
                recordMonthRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getNumRentList())) {
            for (RecordNumRentEntity recordNumRentEntity : recordEntity.getNumRentList()) {
                recordNumRentEntity.setSourceBid(recordNumRentEntity.getId());
                recordNumRentEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getRepairList())) {
            for (RecordRepairEntity recordRepairEntity : recordEntity.getRepairList()) {
                recordRepairEntity.setSourceBid(recordRepairEntity.getId());
                recordRepairEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getScrapList())) {
            for (RecordScrapEntity recordScrapEntity : recordEntity.getScrapList()) {
                recordScrapEntity.setSourceBid(recordScrapEntity.getId());
                recordScrapEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getOtherList())) {
            for (RecordOtherEntity recordOtherEntity : recordEntity.getOtherList()) {
                recordOtherEntity.setSourceBid(recordOtherEntity.getId());
                recordOtherEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getClauseList())) {
            for (RecordClauseEntity recordClauseEntity : recordEntity.getClauseList()) {
                recordClauseEntity.setSourceBid(recordClauseEntity.getId());
                recordClauseEntity.setId(null);
            }
        }
        if (ListUtil.isNotEmpty(recordEntity.getPaymentList())) {
            for (RecordPaymentEntity recordPaymentEntity : recordEntity.getPaymentList()) {
                recordPaymentEntity.setSourceBid(recordPaymentEntity.getId());
                recordPaymentEntity.setId(null);
            }
        }
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u5ba1\u6279-\u53d8\u66f4\u8bb0\u5f55\u8868\u4fdd\u5b58\u4e3b\u5408\u540c\u6570\u636e\u6210\u529f\uff01");
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode(), "arriContract", String.valueOf(recordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u8bb0\u5f55.getCode(), "arriContractRecord");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractVO.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode(), "arriContractFile", String.valueOf(recordEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u8bb0\u5f55.getCode(), "arriContractRecordFile");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)commonResponse));
    }

    public void writeBackContract(ChangeEntity changeEntity, ContractVO contractVO) {
        List clauseList;
        List paymentList;
        List otherList;
        List scrapList;
        List repairList;
        List numRentList;
        List monthRentList;
        List dailyRentList;
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setFirstPartyProjectManagerId(changeEntity.getFirstPartyProjectManagerId());
        contractEntity.setFirstPartyProjectManagerName(changeEntity.getFirstPartyProjectManagerName());
        contractEntity.setFirstPartyEmployeeId(changeEntity.getFirstPartyEmployeeId());
        contractEntity.setFirstPartyEmployeeName(changeEntity.getFirstPartyEmployeeName());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSupplierEmployeeId(changeEntity.getSupplierEmployeeId());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplierAddress(changeEntity.getSupplierAddress());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setTax(changeEntity.getTax());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);
        contractEntity.setRentCalculationType(changeEntity.getRentCalculationType());
        contractEntity.setMonthSettlementDay(changeEntity.getMonthSettlementDay());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setChangeContractName(changeEntity.getContractName());
        contractEntity.setSupplyAddress(changeEntity.getSupplyAddress());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setRentCalculationDate(changeEntity.getRentCalculationDate());
        contractEntity.setEndRentCalculationDate(changeEntity.getEndRentCalculationDate());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangeContractSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString());
        contractEntity.setChangeDraftType(changeEntity.getChangeDraftType());
        contractEntity.setChangeFileId(changeEntity.getChangeFileId());
        if (ListUtil.isNotEmpty((List)contractVO.getDailyRentList())) {
            this.dailyRentService.removeByIds(contractVO.getDailyRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(dailyRentList = BeanMapper.mapList(changeEntity.getDailyRentList(), ContractDailyRentEntity.class)))) {
            for (Object entity : dailyRentList) {
                ((ContractDailyRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractDailyRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setDailyRentList(dailyRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getMonthRentList())) {
            this.monthRentService.removeByIds(contractVO.getMonthRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(monthRentList = BeanMapper.mapList(changeEntity.getMonthRentList(), ContractMonthRentEntity.class)))) {
            for (Object entity : monthRentList) {
                ((ContractMonthRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractMonthRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setMonthRentList(monthRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getNumRentList())) {
            this.numRentService.removeByIds(contractVO.getNumRentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(numRentList = BeanMapper.mapList(changeEntity.getNumRentList(), ContractNumRentEntity.class)))) {
            for (Object entity : numRentList) {
                ((ContractNumRentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractNumRentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setNumRentList(numRentList);
        if (ListUtil.isNotEmpty((List)contractVO.getRepairList())) {
            this.repairService.removeByIds(contractVO.getRepairList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(repairList = BeanMapper.mapList(changeEntity.getRepairList(), ContractRepairEntity.class)))) {
            for (Object entity : repairList) {
                ((ContractRepairEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractRepairEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setRepairList(repairList);
        if (ListUtil.isNotEmpty((List)contractVO.getScrapList())) {
            this.scrapService.removeByIds(contractVO.getScrapList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(scrapList = BeanMapper.mapList(changeEntity.getScrapList(), ContractScrapEntity.class)))) {
            for (Object entity : scrapList) {
                ((ContractScrapEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractScrapEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setScrapList(scrapList);
        if (ListUtil.isNotEmpty((List)contractVO.getOtherList())) {
            this.otherService.removeByIds(contractVO.getOtherList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(otherList = BeanMapper.mapList(changeEntity.getOtherList(), ContractOtherEntity.class)))) {
            for (Object entity : otherList) {
                ((ContractOtherEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractOtherEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setOtherList(otherList);
        if (ListUtil.isNotEmpty((List)contractVO.getPaymentList())) {
            this.paymentService.removeByIds(contractVO.getPaymentList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(paymentList = BeanMapper.mapList(changeEntity.getPaymentList(), ContractPaymentEntity.class)))) {
            for (Object entity : paymentList) {
                ((ContractPaymentEntity)((Object)entity)).setChangeId(changeEntity.getId());
                ((ContractPaymentEntity)((Object)entity)).setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setPaymentList(paymentList);
        if (ListUtil.isNotEmpty((List)contractVO.getClauseList())) {
            this.clauseService.removeByIds(contractVO.getClauseList().stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty((List)(clauseList = BeanMapper.mapList(changeEntity.getClauseList(), ContractClauseEntity.class)))) {
            for (ContractClauseEntity entity : clauseList) {
                entity.setChangeId(changeEntity.getId());
                entity.setChangeBid(entity.getId());
                entity.setId(null);
            }
        }
        contractEntity.setClauseList(clauseList);
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u540c\u6b65\u9644\u4ef6");
        CommonResponse response = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c\u53d8\u66f4.getCode(), "arriContractChange", String.valueOf(contractEntity.getId()), BillTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u79df\u5165\u5408\u540c.getCode(), "arriContract");
        this.logger.info("\u540c\u6b65\u9644\u4ef6::::::::::::\u7ed3\u679c::" + JSONObject.toJSONString((Object)response));
    }

    public void clearDetailList(ChangeEntity changeEntity) {
        if (ListUtil.isNotEmpty(changeEntity.getDailyRentList())) {
            for (ChangeDailyRentEntity changeDailyRentEntity : changeEntity.getDailyRentList()) {
                if (changeDailyRentEntity.getId() != null) {
                    changeDailyRentEntity.setSourceBid(changeDailyRentEntity.getId());
                }
                changeDailyRentEntity.setId(null);
                changeDailyRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getMonthRentList())) {
            for (ChangeMonthRentEntity changeMonthRentEntity : changeEntity.getMonthRentList()) {
                if (changeMonthRentEntity.getId() != null) {
                    changeMonthRentEntity.setSourceBid(changeMonthRentEntity.getId());
                }
                changeMonthRentEntity.setId(null);
                changeMonthRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getNumRentList())) {
            for (ChangeNumRentEntity changeNumRentEntity : changeEntity.getNumRentList()) {
                if (changeNumRentEntity.getId() != null) {
                    changeNumRentEntity.setSourceBid(changeNumRentEntity.getId());
                }
                changeNumRentEntity.setId(null);
                changeNumRentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getRepairList())) {
            for (ChangeRepairEntity changeRepairEntity : changeEntity.getRepairList()) {
                if (changeRepairEntity.getId() != null) {
                    changeRepairEntity.setSourceBid(changeRepairEntity.getId());
                }
                changeRepairEntity.setId(null);
                changeRepairEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getScrapList())) {
            for (ChangeScrapEntity changeScrapEntity : changeEntity.getScrapList()) {
                if (changeScrapEntity.getId() != null) {
                    changeScrapEntity.setSourceBid(changeScrapEntity.getId());
                }
                changeScrapEntity.setId(null);
                changeScrapEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getOtherList())) {
            for (ChangeOtherEntity changeOtherEntity : changeEntity.getOtherList()) {
                if (changeOtherEntity.getId() != null) {
                    changeOtherEntity.setSourceBid(changeOtherEntity.getId());
                }
                changeOtherEntity.setId(null);
                changeOtherEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getPaymentList())) {
            for (ChangePaymentEntity changePaymentEntity : changeEntity.getPaymentList()) {
                if (changePaymentEntity.getId() != null) {
                    changePaymentEntity.setSourceBid(changePaymentEntity.getId());
                }
                changePaymentEntity.setId(null);
                changePaymentEntity.setContractId(changeEntity.getMainContractId());
            }
        }
        if (ListUtil.isNotEmpty(changeEntity.getOtherList())) {
            for (ChangeOtherEntity changeOtherEntity : changeEntity.getOtherList()) {
                if (changeOtherEntity.getId() != null) {
                    changeOtherEntity.setSourceBid(changeOtherEntity.getId());
                }
                changeOtherEntity.setId(null);
                changeOtherEntity.setContractId(changeEntity.getMainContractId());
            }
        }
    }

    public void deleteOldCost(ChangeVO changeVO) {
        ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
        ExecutionVO executionVO = this.targetCost(changeVO);
        totalExecutionVOList.add(executionVO.getTotalVO());
        CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u5220\u9664\u65e7\u76ee\u6807\u6210\u672c\u5931\u8d25\uff01");
        }
    }

    public ExecutionVO targetCost(ChangeVO changeVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(changeVO.getId());
        totalVO.setTenantId(changeVO.getTenantId());
        totalVO.setBillCode(changeVO.getBillCode());
        totalVO.setBillType("BT220210000000005");
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setProjectId(changeVO.getProjectId());
        totalVO.setOrgId(changeVO.getOrgId());
        totalVO.setMoney(changeVO.getContractMny());
        totalVO.setTaxMoney(changeVO.getContractTaxMny());
        totalVO.setLinkUrl(this.baseHost + "ejc-assistrmat-frontend/#/contract/changeCard?id=" + changeVO.getId());
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }
}

