package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.BatchPlanDetailEntity;
import com.ejianc.business.assist.rmat.service.IBatchPlanDetailService;
import com.ejianc.business.assist.rmat.vo.BatchPlanEnum;
import com.ejianc.business.assist.rmat.vo.BatchPlanDetailVO;
import com.ejianc.business.assist.rmat.vo.BatchPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.BatchPlanMapper;
import com.ejianc.business.assist.rmat.bean.BatchPlanEntity;
import com.ejianc.business.assist.rmat.service.IBatchPlanService;

import java.util.ArrayList;
import java.util.List;

/**
 * 周转材批次计划
 *
 * @author generator
 */
@Service("batchPlanService")
public class BatchPlanServiceImpl extends BaseServiceImpl<BatchPlanMapper, BatchPlanEntity> implements IBatchPlanService {
    private static final String BILL_CODE = "ASSISTRMAT_BATCH_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBatchPlanDetailService batchPlanDetailService;

    @Override
    public BatchPlanVO saveOrUpdate(BatchPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        BatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(0);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, BatchPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, BatchPlanEntity.class);
            operateType = "add";
        }
        List<BatchPlanDetailVO> detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        List<String> nameList = new ArrayList<>();
        for (BatchPlanDetailVO detailVO : detailList) {
            if (!nameList.contains(detailVO.getMaterialTypeName())) {
                if (categoryName.length() > 0) {
                    categoryName = categoryName + "," + detailVO.getMaterialTypeName();
                } else {
                    categoryName = detailVO.getMaterialTypeName();
                }
                nameList.add(detailVO.getMaterialTypeName());
                if (categoryName.length() > 100) {
                    break;
                }
            }
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByBatchId(entity.getId());
        }
        List<BatchPlanDetailEntity> detailEntityList = BeanMapper.mapList(detailList,BatchPlanDetailEntity.class);
        if (detailEntityList.size() > 0) {
            for(BatchPlanDetailEntity detailEntity : detailEntityList){
                detailEntity.setBatchId(entity.getId());
            }
            batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public BatchPlanVO queryDetail(Long id) {
        BatchPlanEntity batchPlanEntity = super.selectById(id);
        BatchPlanVO vo = BeanMapper.map(batchPlanEntity,BatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(BatchPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<BatchPlanEntity> entityList = (List<BatchPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (BatchPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】项目名称【" +
                                entity.getProjectName() + "】已采购完成！");
                    }

                    entity.setTenderStatus(planState);
                }
//                entityList.forEach(entity -> {
//                    entity.setPlanState(planState);
//                });
                super.saveOrUpdateBatch(entityList);
            }
        }
    }
}
