/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.LoseEntity;
import com.ejianc.business.assist.rmat.bean.RentCalculateEntity;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.bean.SettleLeaseEntity;
import com.ejianc.business.assist.rmat.bean.SettleLoseEntity;
import com.ejianc.business.assist.rmat.bean.SettleRepairEntity;
import com.ejianc.business.assist.rmat.bean.SettleScrapEntity;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.ILoseService;
import com.ejianc.business.assist.rmat.service.IRentCalculateService;
import com.ejianc.business.assist.rmat.service.IRestituteService;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settle")
public class SettleBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentCalculateService calculateService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ILoseService loseService;
    @Autowired
    private IContractService contractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = (SettleEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(SettleEntity::getCommitDate, (Object)new Date());
        wrapper.set(SettleEntity::getCommitUserCode, (Object)userContext.getUserCode());
        wrapper.set(SettleEntity::getCommitUserName, (Object)userContext.getUserName());
        this.service.update((Wrapper)wrapper);
        if (Objects.equals(settleEntity.getSettleType(), "1")) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ContractEntity::getContractStatus, (Object)ContractStatusEnum.\u5df2\u5c01\u8d26.getCode());
            updateWrapper.eq(BaseEntity::getId, (Object)settleEntity.getContractId());
            this.contractService.update((Wrapper)updateWrapper);
        }
        this.writeSettleFlag(settleEntity, 1);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        SettleEntity entity = (SettleEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        wrapper.eq(SettleEntity::getContractId, (Object)entity.getContractId());
        wrapper.notIn(SettleEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        this.writeSettleFlag(entity, 0);
        return CommonResponse.success();
    }

    public void writeSettleFlag(SettleEntity entity, Integer settleFlag) {
        List<SettleScrapEntity> scrapList;
        ArrayList leaseIdsList = new ArrayList();
        List<SettleLeaseEntity> leaseList = entity.getLeaseList();
        if (ListUtil.isNotEmpty(leaseList)) {
            leaseIdsList.addAll(leaseList.stream().map(SettleLeaseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(leaseIdsList)) {
            LambdaUpdateWrapper leaseWrapper = new LambdaUpdateWrapper();
            leaseWrapper.set(RentCalculateEntity::getSettleFlag, (Object)settleFlag);
            leaseWrapper.in(BaseEntity::getId, leaseIdsList);
            this.calculateService.update((Wrapper)leaseWrapper);
        }
        ArrayList restituteIdsList = new ArrayList();
        List<SettleRepairEntity> repairList = entity.getRepairList();
        if (ListUtil.isNotEmpty(repairList)) {
            restituteIdsList.addAll(repairList.stream().map(SettleRepairEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(scrapList = entity.getScrapList())) {
            restituteIdsList.addAll(scrapList.stream().map(SettleScrapEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(restituteIdsList)) {
            LambdaUpdateWrapper restituteWrapper = new LambdaUpdateWrapper();
            restituteWrapper.set(RestituteEntity::getSettleFlag, (Object)settleFlag);
            restituteWrapper.in(BaseEntity::getId, restituteIdsList);
            this.restituteService.update((Wrapper)restituteWrapper);
        }
        List<SettleLoseEntity> loseList = entity.getLoseList();
        ArrayList loseIdsList = new ArrayList();
        if (ListUtil.isNotEmpty(loseList)) {
            loseIdsList.addAll(loseList.stream().map(SettleLoseEntity::getSourceId).collect(Collectors.toList()));
        }
        if (ListUtil.isNotEmpty(loseIdsList)) {
            LambdaUpdateWrapper loseWrapper = new LambdaUpdateWrapper();
            loseWrapper.set(LoseEntity::getSettleFlag, (Object)settleFlag);
            loseWrapper.in(BaseEntity::getId, loseIdsList);
            this.loseService.update((Wrapper)loseWrapper);
        }
    }
}

