/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.ownrmat.vo.ResidualVO;
import com.ejianc.business.assist.rmat.bean.ConvertEntity;
import com.ejianc.business.assist.rmat.mapper.ConvertMapper;
import com.ejianc.business.assist.rmat.service.IConvertService;
import com.ejianc.business.assist.rmat.vo.ConvertVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="convertService")
public class ConvertServiceImpl
extends BaseServiceImpl<ConvertMapper, ConvertEntity>
implements IConvertService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Boolean saveOrUpdate(ConvertVO saveOrUpdateVO) {
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        saveOrUpdateVO.setTenantId(tenantid);
        String orgCode = this.sessionManager.getUserContext().getOrgCode();
        String orgName = this.sessionManager.getUserContext().getOrgName();
        if (saveOrUpdateVO.getConvertStatus() == 1) {
            List list;
            Integer rowType = saveOrUpdateVO.getRowType();
            LambdaQueryWrapper lambd = new LambdaQueryWrapper();
            lambd.eq(ConvertEntity::getOrgId, (Object)orgId);
            lambd.eq(ConvertEntity::getConvertStatus, (Object)1);
            lambd.eq(ConvertEntity::getRowType, (Object)rowType);
            lambd.eq(ConvertEntity::getUnitId, (Object)saveOrUpdateVO.getUnitId());
            lambd.eq(ConvertEntity::getUnitMId, (Object)saveOrUpdateVO.getUnitMId());
            if (rowType == 1) {
                lambd.eq(ConvertEntity::getMaterialTypeId, (Object)saveOrUpdateVO.getMaterialTypeId());
            } else {
                lambd.eq(ConvertEntity::getMaterialId, (Object)saveOrUpdateVO.getMaterialId());
            }
            if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
                lambd.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)lambd)))) {
                if (rowType == 1) {
                    throw new BusinessException(saveOrUpdateVO.getMaterialTypeName() + "\u5df2\u7ecf\u6709\u542f\u7528\u7684\u91cd\u91cf\u8f6c\u6362\u7cfb\u6570\uff0c\u8bf7\u53d8\u66f4\u72b6\u6001\u540e\uff0c\u63d0\u4ea4\u4fe1\u606f\u3002");
                }
                throw new BusinessException(saveOrUpdateVO.getMaterialName() + "\u5df2\u7ecf\u6709\u542f\u7528\u7684\u91cd\u91cf\u8f6c\u6362\u7cfb\u6570\uff0c\u8bf7\u53d8\u66f4\u72b6\u6001\u540e\uff0c\u63d0\u4ea4\u4fe1\u606f\u3002");
            }
        }
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() <= 0L) {
            saveOrUpdateVO.setOrgId(orgId);
            saveOrUpdateVO.setOrgCode(orgCode);
            saveOrUpdateVO.setOrgName(orgName);
        }
        ConvertEntity entity = (ConvertEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ConvertEntity.class));
        return super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public String turnSwitch(ConvertVO vo) {
        if (vo.getConvertStatus() == 0) {
            LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
            lambd.set(ConvertEntity::getConvertStatus, (Object)0);
            lambd.eq(BaseEntity::getId, (Object)vo.getId());
            super.update((Wrapper)lambd);
            return "\u505c\u7528\u6210\u529f\uff01";
        }
        Integer rowType = vo.getRowType();
        LambdaUpdateWrapper lambd = new LambdaUpdateWrapper();
        lambd.set(ConvertEntity::getConvertStatus, (Object)0);
        lambd.eq(ConvertEntity::getConvertStatus, (Object)1);
        lambd.eq(ConvertEntity::getOrgId, (Object)vo.getOrgId());
        lambd.eq(ConvertEntity::getUnitId, (Object)vo.getUnitId());
        lambd.eq(ConvertEntity::getUnitMId, (Object)vo.getUnitMId());
        lambd.eq(ConvertEntity::getRowType, (Object)rowType);
        if (rowType == 1) {
            lambd.eq(ConvertEntity::getMaterialTypeId, (Object)vo.getMaterialTypeId());
        } else {
            lambd.eq(ConvertEntity::getMaterialId, (Object)vo.getMaterialId());
        }
        lambd.ne(BaseEntity::getId, (Object)vo.getId());
        super.update((Wrapper)lambd);
        LambdaUpdateWrapper lambdUpdate = new LambdaUpdateWrapper();
        lambdUpdate.set(ConvertEntity::getConvertStatus, (Object)1);
        lambdUpdate.eq(BaseEntity::getId, (Object)vo.getId());
        super.update((Wrapper)lambdUpdate);
        return "\u542f\u7528\u6210\u529f\uff01";
    }

    @Override
    public Map<Long, ConvertEntity> getResidualRate(ResidualVO vo) {
        Map<Long, ConvertEntity> rateMap = this.getResidualRateByOrgId(vo);
        return rateMap;
    }

    private Map<Long, ConvertEntity> getResidualRateByOrgId(ResidualVO vo) {
        Long orgId = vo.getOrgId();
        List materialIds = vo.getMaterialIds();
        if (CollectionUtils.isEmpty((Collection)materialIds)) {
            return new HashMap<Long, ConvertEntity>();
        }
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(ConvertEntity::getOrgId, (Object)orgId);
        lambd.eq(ConvertEntity::getConvertStatus, (Object)1);
        List list = super.list((Wrapper)lambd);
        HashMap<Long, ConvertEntity> map = new HashMap<Long, ConvertEntity>();
        ArrayList<ConvertEntity> typeList = new ArrayList<ConvertEntity>();
        for (ConvertEntity entity : list) {
            if (entity.getRowType() == 2 && materialIds.size() > 0) {
                if (!materialIds.contains(entity.getMaterialId())) continue;
                map.put(entity.getMaterialId(), entity);
                materialIds.remove(entity.getMaterialId());
                continue;
            }
            typeList.add(entity);
        }
        if (materialIds.size() == 0) {
            return map;
        }
        if (CollectionUtils.isEmpty(typeList)) {
            OrgVO parentsVo = (OrgVO)this.orgApi.detailById(orgId).getData();
            if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0L) {
                ResidualVO residualVO = new ResidualVO();
                residualVO.setOrgId(parentsVo.getParentId());
                residualVO.setMaterialIds(materialIds);
                Map<Long, ConvertEntity> resMap = this.getResidualRateByOrgId(residualVO);
                map.putAll(resMap);
            }
            return map;
        }
        CommonResponse mapCommonResponse = this.shareMaterialApi.queryCategoryListByMaterialId(materialIds);
        if (!mapCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6750\u6599\u4e0a\u7ea7\u5206\u7c7b\u5931\u8d25");
        }
        Map dataMap = (Map)mapCommonResponse.getData();
        Map<Long, ConvertEntity> residualRateMap = this.getResidualRateByCategory(typeList, dataMap);
        map.putAll(residualRateMap);
        if (residualRateMap.size() != materialIds.size()) {
            OrgVO parentsVo = (OrgVO)this.orgApi.detailById(orgId).getData();
            if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0L) {
                ResidualVO residualVO = new ResidualVO();
                residualVO.setOrgId(parentsVo.getParentId());
                List matIds = BeanMapper.mapList((Iterable)materialIds, Long.class);
                for (Long mid : residualRateMap.keySet()) {
                    if (!matIds.contains(mid)) continue;
                    matIds.remove(mid);
                }
                residualVO.setMaterialIds(matIds);
                Map<Long, ConvertEntity> resMap = this.getResidualRateByOrgId(residualVO);
                map.putAll(resMap);
            }
            return map;
        }
        return map;
    }

    private Map<Long, ConvertEntity> getResidualRateByCategory(List<ConvertEntity> typeList, Map<Long, List<MaterialCategoryVO>> dataMap) {
        HashMap<Long, ConvertEntity> resMap = new HashMap<Long, ConvertEntity>();
        HashMap<Long, ConvertEntity> typeMap = new HashMap<Long, ConvertEntity>();
        for (ConvertEntity entity : typeList) {
            typeMap.put(entity.getMaterialTypeId(), entity);
        }
        block1: for (Long materialId : dataMap.keySet()) {
            List<MaterialCategoryVO> materialCategoryVOS = dataMap.get(materialId);
            for (MaterialCategoryVO vo : materialCategoryVOS) {
                if (!typeMap.containsKey(vo.getId())) continue;
                resMap.put(materialId, (ConvertEntity)((Object)typeMap.get(vo.getId())));
                continue block1;
            }
        }
        return resMap;
    }
}

