package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.mapper.MaterialMapper;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.rmat.vo.MaxTimeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 材料公共接口
 * 
 * @author generator
 * 
 */
@Service("materialService")
public class MaterialServiceImpl implements IMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IStartService startService;

    @Autowired
    private IStopService stopService;

    @Autowired
    private IRestituteService restService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private IRentCalculateService rentService;

    @Autowired
    private MaterialMapper baseMapper;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param1 = Utils.deepCopy(param);// 深拷贝
        param1.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        QueryParam param2 = Utils.deepCopy(param);// 深拷贝
        param2.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));

        Future<JSONArray> future1 = ListCallable.excute(threadPool, param1, checkService);// 验收单
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param1, startService);// 启用单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param1, stopService);// 停用单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param1, restService);// 退赔单
        Future<JSONArray> future5 = ListCallable.excute(threadPool, param1, loseService);// 遗失单
        Future<JSONArray> future6 = ListCallable.excute(threadPool, param2, restService);// 未生效退赔单
        Future<JSONArray> future7 = ListCallable.excute(threadPool, param2, loseService);// 未生效遗失单

        List<CheckEntity> checkList = new ArrayList<>();// 验收单
        List<StartEntity> startList = new ArrayList<>();// 启用单
        List<StopEntity> stopList = new ArrayList<>();// 停用单
        List<RestituteEntity> restList = new ArrayList<>();// 退赔单
        List<LoseEntity> loseList = new ArrayList<>();// 遗失单
        List<RestituteEntity> tempRestList = new ArrayList<>();// 未生效退赔单
        List<LoseEntity> tempLoseList = new ArrayList<>();// 未生效遗失单
        try {
            checkList = JSONObject.parseArray(future1.get().toJSONString(), CheckEntity.class);
            startList = JSONObject.parseArray(future2.get().toJSONString(), StartEntity.class);
            stopList = JSONObject.parseArray(future3.get().toJSONString(), StopEntity.class);
            restList = JSONObject.parseArray(future4.get().toJSONString(), RestituteEntity.class);
            loseList = JSONObject.parseArray(future5.get().toJSONString(), LoseEntity.class);
            if("rest".equals(type)){
                tempLoseList = JSONObject.parseArray(future7.get().toJSONString(), LoseEntity.class);
            } else if("lose".equals(type)){
                tempRestList = JSONObject.parseArray(future6.get().toJSONString(), RestituteEntity.class);
            }
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+计组方式+使用状态，value-物料
        String key = null;
        for(CheckEntity entity : checkList){// 验收单
            for(CheckDetailEntity detail: entity.getCheckDetailList()){
                for(int i = 0; i< 2; i++){// 0-停用，1-启用
                    key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i;
                    MaterialVO vo = new MaterialVO();
                    if(!map.containsKey(key)){
                        vo.setId(key);
                        // 转换材料明细信息
                        this.transferVO(entity, detail, vo);
                        vo.setUseStatus(String.valueOf(i));
                    } else {
                        vo = map.get(key);
                    }
                    // 已进场
                    vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getCheckNumsSum()));
                    // 已启用 = 已进场
                    vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getCheckNumsSum()));
                    map.put(key, vo);
                }
            }
        }
        for(StartEntity entity : startList){// 启用单
            for(StartDetailEntity detail: entity.getDetailList()){
                for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                    key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i;
                    if(!map.containsKey(key)){
                        continue;
                    }
                    MaterialVO vo = map.get(key);
                    if (i == 0){// 已停用 = 已停用 - 已启用
                        vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getNum()));
                    } else {// 已启用
                        vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                    }
                }
            }
        }
        for(StopEntity entity : stopList){// 停用单
            for(StopDetailEntity detail: entity.getDetailList()){
                for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                    key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i;
                    if(!map.containsKey(key)){
                        continue;
                    }
                    MaterialVO vo = map.get(key);
                    if (i == 0){// 已停用
                        vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getNum()));
                    } else {
                        // 已启用 = 已启用 - 已停用
                        vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getNum()));
                    }
                }
            }
        }
        for(RestituteEntity entity : restList){// 退赔单
            for(RestituteDetailEntity detail: entity.getRestituteDetailList()){
                key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum()));
            }
        }
        for(LoseEntity entity : loseList){// 遗失单
            for(LoseDetailEntity detail: entity.getLoseDetailList()){
                key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getLoseNum()));
            }
        }
        for(RestituteEntity entity : tempRestList){// 未生效退赔单
            for(RestituteDetailEntity detail: entity.getRestituteDetailList()){
                key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                vo.setTempRestNum(ComputeUtil.safeAdd(vo.getTempRestNum(), detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum()));
            }
        }
        for(LoseEntity entity : tempLoseList){// 未生效遗失单
            for(LoseDetailEntity detail: entity.getLoseDetailList()){
                key = entity.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                vo.setTempLoseNum(ComputeUtil.safeAdd(vo.getTempLoseNum(), detail.getLoseNum()));
            }
        }
        for(Iterator<MaterialVO> it = map.values().iterator(); it.hasNext();){
            MaterialVO vo = it.next();
            switch(type){
                case "start":// 在场可启用数量 = 已停用 - 已退赔 - 已遗失
                    if("1".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "stop":// 在场可停用数量 = 已启用 - 已退赔 - 已遗失
                    if("0".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "rest":
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    break;
                case "lose":
                    if("0".equals(vo.getUseStatus())){// 可遗失数量 = 已停用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可遗失数量 = 已启用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    break;
                case "report":
                    if("0".equals(vo.getUseStatus())){// 在场停用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 在场启用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    break;
                default:
                    break;
            }
            // 过滤数量小于0
            if(vo.getRefNum() == null || vo.getRefNum().compareTo(BigDecimal.ZERO) <= 0){
                it.remove();
                continue;
            }
            if(StringUtils.isNotEmpty(param.getSearchText())){
                // 模糊搜索合同名称、供应商名称、项目名称
                if("report".equals(type) &&
                        !(vo.getContractName().contains(param.getSearchText()) ||
                        vo.getProjectName().contains(param.getSearchText()) ||
                        vo.getSupplierName().contains(param.getSearchText()) ||
                        (StringUtils.isNotEmpty(vo.getMaterialCode()) && vo.getMaterialCode().contains(param.getSearchText())) ||
                        vo.getMaterialName().contains(param.getSearchText()) ||
                        (StringUtils.isNotEmpty(vo.getMaterialCode()) && vo.getSpec().contains(param.getSearchText())))){
                    it.remove();
                }
                if(!"report".equals(type) &&
                        !((StringUtils.isNotEmpty(vo.getMaterialCode()) && vo.getMaterialCode().contains(param.getSearchText())) ||
                        vo.getMaterialName().contains(param.getSearchText()) ||
                        (StringUtils.isNotEmpty(vo.getMaterialCode()) && vo.getSpec().contains(param.getSearchText())))){
                    // 模糊搜索材料编号、材料名称、规格型号
                    it.remove();
                }
            }
        }
        return new ArrayList<>(map.values());
    }

    /**
     * 转换材料明细信息
     * @param entity
     * @param detail
     * @param vo
     */
    private void transferVO(CheckEntity entity, CheckDetailEntity detail, MaterialVO vo) {
        vo.setContractId(entity.getContractId());
        vo.setContractCode(entity.getContractCode());
        vo.setContractName(entity.getContractName());
        vo.setProjectId(entity.getProjectId());
        vo.setProjectCode(entity.getProjectCode());
        vo.setProjectName(entity.getProjectName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());

        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setRentCalculationType(detail.getRentCalculationType());
        vo.setRentTypeName("2".equals(detail.getRentCalculationType()) ? "工程量租" :
                "1".equals(detail.getRentCalculationType()) ? "月租" :
                "0".equals(detail.getRentCalculationType()) ? "日租" : null);

        vo.setContractRmatMethod(entity.getContractRmatMethod());
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        QueryParam param = Utils.deepCopy(queryParam);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.验收单.equals(billType) ? param : queryParam, checkService);// 验收单
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.启用单.equals(billType) ? param : queryParam, startService);// 启用单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.停用单.equals(billType) ? param : queryParam, stopService);// 停用单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.退赔单.equals(billType) ? param : queryParam, restService);// 退赔单
        Future<JSONArray> future5 = ListCallable.excute(threadPool, MaterialConstant.遗失单.equals(billType) ? param : queryParam, loseService);// 遗失单
        Future<JSONArray> future6 = ListCallable.excute(threadPool, MaterialConstant.租金计算单.equals(billType) ? param : queryParam, rentService);// 租金计算单

        List<CheckEntity> checkList = new ArrayList<>();// 验收单
        List<StartEntity> startList = new ArrayList<>();// 启用单
        List<StopEntity> stopList = new ArrayList<>();// 停用单
        List<RestituteEntity> restList = new ArrayList<>();// 退赔单
        List<LoseEntity> loseList = new ArrayList<>();// 遗失单
        List<RentCalculateEntity> rentList = new ArrayList<>();// 租金计算单
        try {
            checkList = JSONObject.parseArray(future1.get().toJSONString(), CheckEntity.class);
            startList = JSONObject.parseArray(future2.get().toJSONString(), StartEntity.class);
            stopList = JSONObject.parseArray(future3.get().toJSONString(), StopEntity.class);
            restList = JSONObject.parseArray(future4.get().toJSONString(), RestituteEntity.class);
            loseList = JSONObject.parseArray(future5.get().toJSONString(), LoseEntity.class);
            rentList = JSONObject.parseArray(future6.get().toJSONString(), RentCalculateEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(CollectionUtils.isNotEmpty(checkList)){
            throw new BusinessException("当前合同存在非审批通过态的验收单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(startList)){
            throw new BusinessException("当前合同存在非审批通过态的启用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(stopList)){
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(restList)){
            throw new BusinessException("当前合同存在非审批通过态的退赔单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(loseList)){
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(rentList)){
            throw new BusinessException("当前合同存在非审批通过态的租金计算单，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        return list.stream().filter(x->x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String type = "report";// start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账

        // 使用状态(启用、停用)
        Parameter useStatusParameter = param.getParams().get("useStatus");
        List<String> useStatusList = new ArrayList<>();
        if(useStatusParameter != null && useStatusParameter.getValue() != null){
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        // 租赁方式(内租、外租)
        Parameter contractRmatMethodParameter = param.getParams().get("contractRmatMethod");
        List<String> contractRmatMethodList = new ArrayList<>();
        if(contractRmatMethodParameter != null && contractRmatMethodParameter.getValue() != null){
            String contractRmatMethod = (String)contractRmatMethodParameter.getValue();
            String[] split = contractRmatMethod.split(",");
            contractRmatMethodList = Arrays.asList(split);
            param.getParams().remove("contractRmatMethod");
        }
        // 计租方式(日租、月租、工程量租)
        Parameter rentCalculationTypeParameter = param.getParams().get("rentCalculationType");
        List<String> rentCalculationTypeList = new ArrayList<>();
        if(rentCalculationTypeParameter != null && rentCalculationTypeParameter.getValue() != null){
            String rentCalculationType = (String)rentCalculationTypeParameter.getValue();
            String[] split = rentCalculationType.split(",");
            rentCalculationTypeList = Arrays.asList(split);
            param.getParams().remove("rentCalculationType");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);

        List<MaterialVO> resList = new ArrayList<>();
        for(MaterialVO vo : list){
            boolean flag = false;
            if(useStatusList.size()>0 && !useStatusList.contains(vo.getUseStatus())){
                flag = true;
            }
            if(contractRmatMethodList.size()>0 && !contractRmatMethodList.contains(vo.getContractRmatMethod())){
                flag = true;
            }
            if(rentCalculationTypeList.size()>0 && !rentCalculationTypeList.contains(vo.getRentCalculationType())){
                flag = true;
            }
            if(!flag){
                resList.add(vo);
            }
        }
        resList.forEach(vo -> {
            if (null != vo.getContractRmatMethod()) {
                if ("0".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("外租");
                } else if ("1".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("内租");
                }
            } else {
                vo.setContractRmatMethodName("");
            }
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("停用");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("启用");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }

}
