package com.ejianc.business.assist.rmat.utils;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/**
 * @author yqls
 * @date 2021-05-24 18:23:16
 */
@Component
public class EntityUtil<T> {

    public static <T> List<T> setDetailList(List<T> list) {
        if(list != null && list.size() > 0) {
            list.forEach(entity->{
                Class<?> mainClass = entity.getClass();
                Field[] fields = mainClass.getDeclaredFields();
                /** 查找字表字段 可能有多个子表*/
                for (Field field : fields) {
                    if(field.isAnnotationPresent(SubEntity.class)){
                        SubEntity subEntity = field.getAnnotation(SubEntity.class);
                        String serviceName = subEntity.serviceName();
                        String fieldName = field.getName();
                        if(StringUtils.isBlank(serviceName)){
                            throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                        }
                        BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                        if(subService==null){
                            throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                        }
                        try {
                            Method m =  mainClass.getMethod("getId",  null);
                            /** 获取子表数据 */
                            Long id = (Long)m.invoke(entity, null);
                            QueryParam queryParam = new QueryParam();
                            queryParam.getParams().put(subEntity.pidName(), new Parameter(QueryParam.EQ, id));
                            queryParam.getOrderMap().put("id",QueryParam.ASC);
                            List<BaseEntity> subList = subService.queryList(queryParam,false);

                            if(!ListUtil.isEmpty(subList)){
                                Class[] cArg = new Class[1];
                                cArg[0] = field.getType();
                                Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
                                setSubList.invoke(entity,subList);
                            }
                        } catch (NoSuchMethodException e) {
                            throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                        } catch (IllegalAccessException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                        } catch (InvocationTargetException e) {
                            throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                        }

                    }
                }
            });
        }
        return list;
    }

    /**
     *  根据属性值查询某条数据，包含dr=1的数据
     * @param column    字段
     * @param val   字段值
     * @param mainClass 类
     * @param <T>   泛值
     * @return
     */
    public static <T> T selectOne(String column, Object val, Class<T> mainClass) {
        String className = mainClass.getSimpleName();
        if(!className.contains("Entity")){
            return null;
        }
        className = className.substring(0,1).toLowerCase()+className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
        QueryWrapper<T> ew = new QueryWrapper<>();
        ew.eq("tenant_id", InvocationInfoProxy.getTenantid());
        ew.eq(camel2under(column), val);
        T entity = (T) service.getOne(ew);
        setDetailList(entity);
        return entity;
    }

    /**
     *  根据属性值查询某条数据，包含dr=1的数据
     * @param column    字段
     * @param val   字段值
     * @param serviceClass Service类
     * @param <T>   泛值
     * @return
     */
    public static <T> T selectOneService(String column, Object val, Class<?> serviceClass) {
        String serviceName = serviceClass.getAnnotation(Service.class).value();
        BaseServiceImpl service = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
        QueryWrapper<T> ew = new QueryWrapper<>();
        ew.eq("tenant_id", InvocationInfoProxy.getTenantid());
        ew.eq(camel2under(column), val);
        T entity = (T) service.getOne(ew);
        setDetailList(entity);
        return entity;
    }

    /**
     * 包含dr=1的数据
     * @param entity
     * @param <T>
     * @return
     */
    public static <T> T setDetailList(T entity) {
        if(entity==null){
            return null;
        }
        Class<?> mainClass = entity.getClass();
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        for (Field field : fields) {
            if(field.isAnnotationPresent(SubEntity.class)){
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                String serviceName = subEntity.serviceName();
                String fieldName = field.getName();
                if(StringUtils.isBlank(serviceName)){
                    throw new BusinessException("子表字段【"+fieldName+"】注解SubEntity未设置子表实现类服务名！");
                }
                BaseServiceImpl subService = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
                if(subService==null){
                    throw new BusinessException("字段【"+fieldName+"】子表没有实现类！");
                }
                try {
                    Method m =  mainClass.getMethod("getId",  null);
                    /** 获取子表数据 */
                    Long id = (Long)m.invoke(entity, null);
                    QueryWrapper<BaseEntity> ew = new QueryWrapper<>();
                    ew.eq(camel2under(subEntity.pidName()), id);
                    ew.orderByAsc("id");
                    List<BaseEntity> subList = subService.list(ew);

                    if(!ListUtil.isEmpty(subList)){
                        Class[] cArg = new Class[1];
                        cArg[0] = field.getType();
                        Method setSubList = mainClass.getDeclaredMethod("set"+fieldName.substring(0,1).toUpperCase()+fieldName.substring(1),cArg);
                        setSubList.invoke(entity,subList);
                    }
                } catch (NoSuchMethodException e) {
                    throw new BusinessException("字段【"+fieldName+"】未定义set方法！");
                } catch (IllegalAccessException e) {
                    throw new BusinessException("字段【"+fieldName+"】set方法需要是public属性！");
                } catch (InvocationTargetException e) {
                    throw new BusinessException("字段【"+fieldName+"】set方法执行出错！");
                }

            }
        }
		return entity;
    }

    /**
     * 驼峰命名转下划线命名
     * 小写和大写紧挨在一起的地方，加上分隔符，然后全部转小写
     * @param str
     * @return
     */
    public static String camel2under(String str) {
        if(StringUtils.isEmpty(str)){
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for(int i = 0; i < str.length(); i++){
            char c = str.charAt(i);
            if(Character.isUpperCase(c)){
                sb.append("_");
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }
}
