/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.ejianc.business.assist.rmat.bean.StartEntity;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.service.IStartService;
import com.ejianc.business.assist.rmat.vo.StartVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="start")
public class StartBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IStartService service;
    @Autowired
    private IMaterialService materialService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StartEntity entity = (StartEntity)((Object)this.service.selectById(billId));
        boolean pushResult = this.service.pushBillToSupCenter(entity);
        if (pushResult) {
            entity.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        } else {
            this.logger.error("\u5355\u636e-{}id-{}\u63a8\u9001\u4f9b\u5e94\u5546\u670d\u52a1\u5931\u8d25", (Object)BillTypeEnum.\u542f\u7528\u5355.getName(), (Object)billId);
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        StartEntity entity = (StartEntity)((Object)this.service.selectById(billId));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u7b7e\u5b57\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
        }
        this.materialService.validateContract(entity.getContractId(), null, null, "\u5f03\u5ba1");
        this.service.validateTime((StartVO)BeanMapper.map((Object)((Object)entity), StartVO.class), "\u5f03\u5ba1");
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        boolean pushResult = this.service.delPushBill(entity);
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag()) && !pushResult) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u4f5c\u5e9f\u534f\u540c\u670d\u52a1\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u5f03\u5ba1\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

