package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.ownrmat.vo.ResidualVO;
import com.ejianc.business.assist.rmat.vo.ConvertVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.assist.rmat.mapper.ConvertMapper;
import com.ejianc.business.assist.rmat.bean.ConvertEntity;
import com.ejianc.business.assist.rmat.service.IConvertService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 转换系数设置
 *
 * @author generator
 */
@Service("convertService")
public class ConvertServiceImpl extends BaseServiceImpl<ConvertMapper, ConvertEntity> implements IConvertService {

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Boolean saveOrUpdate(ConvertVO saveOrUpdateVO) {
        Long orgId = InvocationInfoProxy.getOrgId();
        Long tenantid = InvocationInfoProxy.getTenantid();
        saveOrUpdateVO.setTenantId(tenantid);
        String orgCode = sessionManager.getUserContext().getOrgCode();
        String orgName = sessionManager.getUserContext().getOrgName();
        // 校验启用,同一组织下
        if (saveOrUpdateVO.getConvertStatus() == 1) {
            Integer rowType = saveOrUpdateVO.getRowType();
            LambdaQueryWrapper<ConvertEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(ConvertEntity::getConvertStatus, 1);
            lambd.eq(ConvertEntity::getRowType, rowType);
            lambd.eq(ConvertEntity::getUnitId, saveOrUpdateVO.getUnitId());
            lambd.eq(ConvertEntity::getUnitMId, saveOrUpdateVO.getUnitMId());
            if (rowType == 1) {
                lambd.eq(ConvertEntity::getMaterialTypeId, saveOrUpdateVO.getMaterialTypeId());
            } else {
                lambd.eq(ConvertEntity::getMaterialId, saveOrUpdateVO.getMaterialId());
            }
            if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0) { //修改
                lambd.eq(ConvertEntity::getOrgId, saveOrUpdateVO.getOrgId());
                lambd.ne(ConvertEntity::getId, saveOrUpdateVO.getId());
            } else {
                lambd.eq(ConvertEntity::getOrgId, orgId);
            }
            List<ConvertEntity> list = super.list(lambd);
            if (CollectionUtils.isNotEmpty(list)) {
                if (rowType == 1) {
                    throw new BusinessException(saveOrUpdateVO.getMaterialTypeName() + "已经有启用的重量转换系数，请变更状态后，提交信息。");
                } else {
                    throw new BusinessException(saveOrUpdateVO.getMaterialName() + "已经有启用的重量转换系数，请变更状态后，提交信息。");
                }

            }
        }
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() <= 0) { //新增
            saveOrUpdateVO.setOrgId(orgId);
            saveOrUpdateVO.setOrgCode(orgCode);
            saveOrUpdateVO.setOrgName(orgName);
        }
        ConvertEntity entity = BeanMapper.map(saveOrUpdateVO, ConvertEntity.class);
        return super.saveOrUpdate(entity, false);
    }

    @Override
    public String turnSwitch(ConvertVO vo) {
        if (vo.getConvertStatus() == 0) {
            LambdaUpdateWrapper<ConvertEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(ConvertEntity::getConvertStatus, 0);
            lambd.eq(ConvertEntity::getId, vo.getId());
            super.update(lambd);
            return "停用成功！";
        } else {
            // 先停用已启用的
            Integer rowType = vo.getRowType();
            LambdaUpdateWrapper<ConvertEntity> lambd = new LambdaUpdateWrapper<>();
            lambd.set(ConvertEntity::getConvertStatus, 0);
            lambd.eq(ConvertEntity::getConvertStatus, 1);
            lambd.eq(ConvertEntity::getOrgId, vo.getOrgId());
            lambd.eq(ConvertEntity::getUnitId, vo.getUnitId());
            lambd.eq(ConvertEntity::getUnitMId, vo.getUnitMId());
            lambd.eq(ConvertEntity::getRowType, rowType);
            if (rowType == 1) {
                lambd.eq(ConvertEntity::getMaterialTypeId, vo.getMaterialTypeId());
            } else {
                lambd.eq(ConvertEntity::getMaterialId, vo.getMaterialId());
            }
            lambd.ne(ConvertEntity::getId, vo.getId());
            super.update(lambd);

            // 启用
            LambdaUpdateWrapper<ConvertEntity> lambdUpdate = new LambdaUpdateWrapper<>();
            lambdUpdate.set(ConvertEntity::getConvertStatus, 1);
            lambdUpdate.eq(ConvertEntity::getId, vo.getId());
            super.update(lambdUpdate);
            return "启用成功！";
        }
    }

    @Override
    public Map<Long, ConvertEntity> getResidualRate(ResidualVO vo) {
        Map<Long, ConvertEntity> rateMap = getResidualRateByOrgId(vo);
        return rateMap;
    }

    private Map<Long, ConvertEntity> getResidualRateByOrgId(ResidualVO vo) {
        Long orgId = vo.getOrgId();
        List<Long> materialIds = vo.getMaterialIds();
        if (CollectionUtils.isEmpty(materialIds)) {
            return new HashMap<>();
        }

        LambdaQueryWrapper<ConvertEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(ConvertEntity::getOrgId, orgId);
        lambd.eq(ConvertEntity::getConvertStatus, 1);
        List<ConvertEntity> list = super.list(lambd);// 包含材料和分类

        Map<Long, ConvertEntity> map = new HashMap<>();

        List<ConvertEntity> typeList = new ArrayList<>(); // 只有材料分类

        for (ConvertEntity entity : list) {
            if (entity.getRowType() == 2 && materialIds.size() > 0) {
                if (materialIds.contains(entity.getMaterialId())) {
                    map.put(entity.getMaterialId(), entity);
                    materialIds.remove(entity.getMaterialId());
                }
            } else {
                typeList.add(entity);
            }
        }
        if (materialIds.size() == 0) {
            // 已经全部查出
            return map;
        } else {
            if (CollectionUtils.isEmpty(typeList)) {
                // 没有分类，查上级组织
                OrgVO parentsVo = orgApi.detailById(orgId).getData();
                if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0) {
                    ResidualVO residualVO = new ResidualVO();
                    residualVO.setOrgId(parentsVo.getParentId());
                    residualVO.setMaterialIds(materialIds);
                    Map<Long, ConvertEntity> resMap = getResidualRateByOrgId(residualVO);
                    map.putAll(resMap);
                }

                return map;
            } else {
                // 先查上级分类
                CommonResponse<Map<Long, List<MaterialCategoryVO>>> mapCommonResponse = shareMaterialApi.queryCategoryListByMaterialId(materialIds);
                if (!mapCommonResponse.isSuccess()) {
                    throw new BusinessException("查询材料上级分类失败");
                }
                Map<Long, List<MaterialCategoryVO>> dataMap = mapCommonResponse.getData();
                Map<Long, ConvertEntity> residualRateMap = getResidualRateByCategory(typeList, dataMap);
                map.putAll(residualRateMap);
                if (residualRateMap.size() != materialIds.size()) {
                    // 剩下的查上级组织
                    OrgVO parentsVo = orgApi.detailById(orgId).getData();
                    if (parentsVo.getParentId() != null && parentsVo.getParentId() > 0) {
                        ResidualVO residualVO = new ResidualVO();
                        residualVO.setOrgId(parentsVo.getParentId());
                        List<Long> matIds = BeanMapper.mapList(materialIds, Long.class);
                        for (Long mid : residualRateMap.keySet()) {
                            if (matIds.contains(mid)) {
                                matIds.remove(mid);
                            }
                        }
                        residualVO.setMaterialIds(matIds);
                        Map<Long, ConvertEntity> resMap = getResidualRateByOrgId(residualVO);
                        map.putAll(resMap);
                    }
                    return map;
                } else {
                    return map;
                }
            }
        }
    }

    private Map<Long, ConvertEntity> getResidualRateByCategory(List<ConvertEntity> typeList, Map<Long, List<MaterialCategoryVO>> dataMap) {
        Map<Long, ConvertEntity> resMap = new HashMap<>();
        Map<Long, ConvertEntity> typeMap = new HashMap<>();
        for (ConvertEntity entity : typeList) {
            typeMap.put(entity.getMaterialTypeId(), entity);
        }
        for (Long materialId : dataMap.keySet()) {
            List<MaterialCategoryVO> materialCategoryVOS = dataMap.get(materialId);
            for (MaterialCategoryVO vo : materialCategoryVOS) {
                if (typeMap.containsKey(vo.getId())) {
                    resMap.put(materialId, typeMap.get(vo.getId()));
                    break;
                }
            }
        }
        return resMap;
    }
}
