/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractRelieveEntity;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.mapper.ContractRelieveMapper;
import com.ejianc.business.assist.rmat.service.IContractRelieveService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.vo.ContractRelieveVO;
import com.ejianc.business.assist.rmat.vo.record.RelieveRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRelieveService")
public class ContractRelieveServiceImpl
extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity>
implements IContractRelieveService {
    private static final String PRORMAT_CONTRACT_RELIEVE = "PRORMAT_CONTRACT_RELIEVE";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractService contractService;

    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveOrUpdateVO) {
        ContractEntity contractEntity;
        ContractRelieveEntity entity = (ContractRelieveEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractRelieveEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRORMAT_CONTRACT_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()))) == null || Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.\u5df2\u5c01\u8d26.getCode()) || Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.\u5df2\u89e3\u9664.getCode()) || Objects.equals(contractEntity.getContractStatus(), ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode())) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5408\u540c\u6216\u5408\u540c\u72b6\u6001\u4e3a\u672a\u7b7e\u8ba2\u6216\u5df2\u5c01\u8d26\u6216\u5df2\u89e3\u9664\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)entity.getContractId()));
        List list = this.queryList(param);
        if (list.size() > 1) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u80fd\u6709\u4e00\u4efd\u5408\u540c\u89e3\u9664\u534f\u8bae!");
        }
        if (entity.getDraftType() == 1) {
            entity.setSignatureStatus(0);
        }
        this.saveOrUpdate((Object)entity, false);
        return (ContractRelieveVO)BeanMapper.map((Object)((Object)entity), ContractRelieveVO.class);
    }

    @Override
    public Boolean addRelieveFlag(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter("eq", (Object)id));
        List list = this.queryList(param);
        return ListUtil.isEmpty((List)list);
    }

    @Override
    public RelieveRecordVO queryRelieveRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        RelieveRecordVO vo = new RelieveRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRelieveEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, ContractRelieveVO.class));
        return vo;
    }
}

