package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.DraftTypeEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.service.IChangeService;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {
	
	private Logger logger = LoggerFactory.getLogger(this.getClass());

//	public static final String CONTRACT_BILL_TYPE = "BT220210000000004";
//	public static final String CONTRACT_CHANGE_BILL_TYPE = "BT220210000000005";
//	public static final String CONTRACT_SOURCE_TYPE = "prormatContract";
//	public static final String CONTRACT_CHANGE_SOURCE_TYPE = "prormatContractChange";
	
	@Autowired
	private IChangeService service;

	@Autowired
	private IContractService contractService;
	@Autowired
	private IAttachmentApi attachmentApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ChangeEntity changeEntity = service.selectById(billId);

//		logger.info("--------------处理变更附件");
//		CommonResponse<String> response = attachmentApi.copyFilesFromSourceBillToTargetBill(
//				String.valueOf(billId), CONTRACT_CHANGE_BILL_TYPE, CONTRACT_CHANGE_SOURCE_TYPE,
//				String.valueOf(changeEntity.getContractId()), CONTRACT_BILL_TYPE, CONTRACT_SOURCE_TYPE);

		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			// 调用生效回写服务
			return service.effectiveSaveWriteContract(billId, billTypeCode, false);
		}else {
			LambdaUpdateWrapper<ChangeEntity> wrapper = new LambdaUpdateWrapper<>();
			wrapper.set(ChangeEntity::getCommitDate, new Date());
			wrapper.eq(ChangeEntity::getId, billId);
			service.update(wrapper);
			
			// 回写主合同信息
			LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更单据审批通过.getCode());
			updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
			contractService.update(updateWrapper);
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}

	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		ChangeEntity changeEntity = service.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(changeEntity.getSignatureStatus()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		changeEntity.setCommitDate(null);
//		changeEntity.setCommitUserCode(null);
//		changeEntity.setCommitUserName(null);
		changeEntity.setContractStatus(ContractStatusEnum.履约中.getCode());
		service.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}

}
