package com.ejianc.business.assist.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.utils.PageUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料公共接口
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("material")
public class MaterialController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialService service;
    @Autowired
    private IOrgApi iOrgApi;

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> refMaterialData(@RequestParam Integer pageNumber,
            @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
//        param.setSearchObject(searchObject);
//        param.getFuzzyFields().add("contractName");
//        param.getFuzzyFields().add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String type = "report";// start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject json = JSONObject.parseObject(condition);
            if(condition.contains("type")){
                type = json.getString("type");
            }
            if(condition.contains("contractId")){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, json.getString("contractId")));
            }
        }
        List<MaterialVO> list = service.queryCheckList(param, type);
        List<MaterialVO> records = PageUtil.listToPage(list, pageNumber, pageSize);
        IPage<MaterialVO> page = new Page<>();
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(list.size());
        return CommonResponse.success("查询参照数据成功！", page);
     }

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（验收单、启用单、停用单、退赔单、遗失单、租金计算单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId,
           @RequestParam(value = "billType", required = false) String billType,
           @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateContract(contractId, billType, billId, MaterialConstant.保存);
        return CommonResponse.success("校验成功！", msg);
    }

    /**
     * @Description getLastDate 获取最大单据日期
     * @param params contractId，billType，billId
     */
    @RequestMapping(value = "/getLastDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> getLastDate(@RequestParam(required = false) Map<String, Object> params) {
        Date date = service.getLastDate(params);
        return CommonResponse.success("校验成功！", date);
    }

    @RequestMapping(value = "/proMaterialList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> proMaterialList(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<MaterialVO> resList = service.proMaterialList(param);
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        List<MaterialVO> records = PageUtil.listToPage(resList, pageNumber, pageSize);
        IPage<MaterialVO> page = new Page<>();
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(resList.size());
        return CommonResponse.success("查询项目周转材台账成功！", page);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<MaterialVO> resList = service.proMaterialList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("proMaterialList-export.xlsx", beans, response);
    }
}
