package com.ejianc.business.assist.rmat.service;

import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.vo.LoseVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.assist.rmat.vo.record.SettleRecordVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 周转材租赁结算单
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {

    SettleVO saveOrUpdate(SettleVO saveOrUpdateVO);
    
    String validateContract(Long contractId, Long billId);

    List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate);

    List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate);

    SettleVO queryLastSettleTaxMny(Long contractId, Long billId);

    SettleRecordVO querySettleRecord(Long id);

    Boolean pushSettleToPool(SettleVO vo);

    Boolean delSettleFromPool(Long id);
    
}
