package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.assist.rmat.bean.ContractDailyRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.ContractMonthRentEntity;
import com.ejianc.business.assist.rmat.bean.ContractNumRentEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ChangeStatusEnum;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.SignatureStatusEnum;
import com.ejianc.business.assist.rmat.mapper.ContractMapper;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.SupplementRecordVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRmatApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 周转材租赁合同
 * 
 * @author generator
 * 
 */
@Service("contractService")
public class ContractServiceImpl extends BaseServiceImpl<ContractMapper, ContractEntity> implements IContractService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String BILL_CODE = "ASSIST_RMAT_RENT_IN_CONTRACT";//此处需要根据实际修改
    private static final String OPERATE = "CONTRACT_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.辅料中心租入合同.getCode();
    private static final String BILL_NAME = BillTypeEnum.辅料中心租入合同.getName();

    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/contract/billDel";
    
    
    @Autowired
    private IBillCodeApi billCodeApi;
    
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITenderRmatApi tenderRmatApi;

    @Autowired
    private IExecutionApi executionApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private PushSupUtil pushSupUtil;

    @Autowired
    private IContractPoolApi contractPoolApi;
    
    @Override
    public ContractVO saveOrUpdate(ContractVO saveOrUpdateVO) {
        ContractEntity entity = BeanMapper.map(saveOrUpdateVO, ContractEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            
            // 设置合同初始状态
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            if (entity.getSupplementFlag() == 1) {
                Boolean flag = addSupplementFlag(saveOrUpdateVO.getMainContractId());
                if (!flag) {
                    throw new BusinessException("当前合同存在未生效的补充协议，不能新增！");
                }
            }else {
                entity.setMainContractCreateDate(new Date());
            }
            
            // 回写定标结果占据状态
            if (entity.getTargetResultId() != null) {
                tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
            }
        }else {
            // 若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
            ContractEntity oldContractEntity = super.selectById(entity.getId());
            if (null != entity.getTargetResultId() && !entity.getTargetResultId().equals(oldContractEntity.getTargetResultId())){
                tenderRmatApi.updateById(oldContractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                tenderRmatApi.updateById(entity.getTargetResultId(), CommonConstant.OCCUPY_STATE);
                
                // 删除定标带出的数据
                List<Long> dailyIdsList = oldContractEntity.getDailyRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
                    if (dailyIdsList.contains(dailyRentEntity.getId())) {
                        dailyRentEntity.setRowState("del");
                    }
                }

                List<Long> monthIdsList = oldContractEntity.getMonthRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
                    if (monthIdsList.contains(monthRentEntity.getId())) {
                        monthRentEntity.setRowState("del");
                    }
                }

                List<Long> numIdsList = oldContractEntity.getNumRentList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
                    if (numIdsList.contains(numRentEntity.getId())) {
                        numRentEntity.setRowState("del");
                    }
                }
            }
            
            
        }
        
        // 设置初始金额、变更前金额
        entity.setBaseTaxMny(entity.getContractTaxMny()); // 初始版本金额(含税)
        entity.setBaseMny(entity.getContractMny()); // 初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny()); // 变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny()); // 变更前金额(不含税)
        
        // 设置日租、月租、工程量租剩余数量
        for (ContractDailyRentEntity dailyRentEntity : entity.getDailyRentList()) {
            dailyRentEntity.setSurplusCount(dailyRentEntity.getCount());
        }
        for (ContractMonthRentEntity monthRentEntity : entity.getMonthRentList()) {
            monthRentEntity.setSurplusCount(monthRentEntity.getCount());
        }
        for (ContractNumRentEntity numRentEntity : entity.getNumRentList()) {
            numRentEntity.setSurplusCount(numRentEntity.getCount());
        }
        
        this.saveOrUpdate(entity, false);

        ContractVO contractVO = queryDetail(entity.getId());

        // 推送目标成本
//        CommonResponse<String> response = executionApi.aggPush(targetCost(contractVO));
//        logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(contractVO)));
//        if (!response.isSuccess()){
//            logger.error("推送目标成本失败: , {}", response.getMsg());
//            throw new BusinessException(response.getMsg());
//        }

        return contractVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = this.selectById(id);
        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        
        setRowState(vo);
        
        return vo;
    }

    @Override
    public String delete(List<ContractVO> vos) {
        List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (ContractVO vo : vos) {
                ExecutionVO executionVO = this.targetCost(BeanMapper.map(this.getById(vo.getId()), ContractVO.class));
                totalExecutionVOList.add(executionVO.getTotalVO());
                
                // 删除定标占用状态
                ContractEntity contractEntity = this.getById(vo.getId());
                if (null != contractEntity.getTargetResultId()){
                    CommonResponse<String>  tender = tenderRmatApi.updateById(contractEntity.getTargetResultId(), CommonConstant.UN_OCCUPY_STATE);
                    logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
                }
            }
        }
        
        CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
        if (!response.isSuccess()){
            throw new BusinessException("目标成本删除失败！");
        }
        
        this.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        
        
        return "删除成功！";
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // 项合同编号、目名称、合同名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("firstPartyEmployeeName");
        
        
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("supplement_flag", new Parameter("eq", 0));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }

        // 无项目直接根据orgId过滤
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();

        //设置排序：为了保证主合同与补充协议排列在一起，先用主合同创建时间排序
        if(null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        }else {
            orderMap.put("main_contract_create_date", QueryParam.DESC);
        }
        orderMap.put("supplement_flag", QueryParam.ASC);
        orderMap.put("create_time", QueryParam.DESC);

        param.setOrderMap(orderMap);
        IPage<ContractEntity> pageData = this.queryPage(param,false);

        // 页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("contractCount", contractAmountMap);

        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("round(sum(base_tax_mny),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
        
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        // 一个主合同仅有一个未生效得补充协议、单据生效： 当单据审批通过，且签章状态为已签章
        LambdaQueryWrapper<ContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractEntity::getMainContractId, id);
        lambda.eq(ContractEntity::getSupplementFlag, ContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(ContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode()))
                .or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()))
                .or(c -> c.eq(ContractEntity::getContractStatus, String.valueOf(ContractStatusEnum.已解除.getCode()))));
        List<ContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
        
    }

    @Override
    public SupplementRecordVO querySupplementRecord(Long id) {
        ContractEntity entity = this.selectById(id);
        SupplementRecordVO vo = new SupplementRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        
        // 查询补充协议
        LambdaQueryWrapper<ContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractEntity::getMainContractId, id);
        wrapper.orderByDesc(ContractEntity::getSignDate);
        List<ContractEntity> supplementList = super.list(wrapper);

        vo.setSupplementToalTaxMny(supplementList.stream().filter(e -> e.getContractTaxMny() != null).map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().filter(e -> e.getContractMny() != null).map(ContractEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementNum(supplementList.size());
        vo.setSupplementMnyRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(vo.getSupplementToalTaxMny(), vo.getContractTaxMny()), new BigDecimal("100")));
        
        vo.setDetailList(BeanMapper.mapList(supplementList, ContractVO.class));
        
        return vo;
    }
    
    public void setRowState(ContractVO vo) {
        // 日租
        if(ListUtil.isNotEmpty(vo.getDailyRentList())){
            vo.getDailyRentList().forEach(e -> e.setRowState("edit"));
        }
        // 月租
        if(ListUtil.isNotEmpty(vo.getMonthRentList())){
            vo.getMonthRentList().forEach(e -> e.setRowState("edit"));
        }
        // 工程量租
        if(ListUtil.isNotEmpty(vo.getNumRentList())){
            vo.getNumRentList().forEach(e -> e.setRowState("edit"));
        }
        // 维修
        if(ListUtil.isNotEmpty(vo.getRepairList())){
            vo.getRepairList().forEach(e -> e.setRowState("edit"));
        }
        // 报废
        if(ListUtil.isNotEmpty(vo.getScrapList())){
            vo.getScrapList().forEach(e -> e.setRowState("edit"));
        }
        // 其他费用
        if(ListUtil.isNotEmpty(vo.getOtherList())){
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        // 付款计划
        if(ListUtil.isNotEmpty(vo.getPaymentList())){
            vo.getPaymentList().forEach(e -> e.setRowState("edit"));
        }
        // 合同条款
        if(ListUtil.isNotEmpty(vo.getOtherList())){
            vo.getOtherList().forEach(e -> e.setRowState("edit"));
        }
        
    }

    public ExecutionVO targetCost(ContractVO contractVO) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType("BT220210000000004");
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.周转材租赁合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(baseHost + "ejc-assistrmat-frontend/#/contract/card?id=" + contractVO.getId());
        
        executionVO.setTotalVO(totalVO);
        
        return executionVO;
    }

    /**
     * 单据推送到供方协同服务
     * @param entity
     * @return
     */
    @Override
    public Boolean pushBillToSupCenter(ContractEntity entity) {
        Boolean syncFlag = pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    /**
     * 将推送至供方的单据作废
     * @param entity
     * @return
     */
    @Override
    public Boolean delPushBill(ContractEntity entity) {
        Boolean delSuc = pushSupUtil.delPushBill((JSONObject) JSONObject.toJSON(entity), OPERATE,
                BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
        
    }

    @Override
    public Boolean pushContract(ContractVO vo) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(vo, data);
            data.setSourceType(ContractTypeEnum.周转材合同.getTypeCode());
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);

            if(transDataResp.isSuccess()) {
                return true;
            } else {
                logger.error("合同id-{}推送合同池失败，{}",vo.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", vo.getId(), e);
        }
        
        
        
        return null;
    }


}
