/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.rmat.bean.ContractEntity;
import com.ejianc.business.assist.rmat.bean.LoseEntity;
import com.ejianc.business.assist.rmat.bean.RestituteEntity;
import com.ejianc.business.assist.rmat.bean.SettleEntity;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.mapper.SettleMapper;
import com.ejianc.business.assist.rmat.service.IContractService;
import com.ejianc.business.assist.rmat.service.ILoseService;
import com.ejianc.business.assist.rmat.service.IRestituteService;
import com.ejianc.business.assist.rmat.service.ISettleService;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.vo.LoseVO;
import com.ejianc.business.assist.rmat.vo.RestituteVO;
import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.assist.rmat.vo.record.SettleRecordVO;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleService")
public class SettleServiceImpl
extends BaseServiceImpl<SettleMapper, SettleEntity>
implements ISettleService {
    private static final String PRO_RMAT_SETTLE = "PRO_RMAT_SETTLE";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private ILoseService loseService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ISettlePoolApi settlePoolApi;

    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {
        int compareDate;
        SettleEntity entity = (SettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SettleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)PRO_RMAT_SETTLE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setSupplierSignStatus(0);
        }
        this.validateContract(entity.getContractId(), entity.getId());
        SettleVO lastVo = this.queryLastSettleTaxMny(entity.getContractId(), entity.getId());
        if (lastVo.getId() != null && (compareDate = DateUtil.compareDate(lastVo.getSettleDate(), entity.getSettleDate())) > 0) {
            throw new BusinessException("\u672c\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate(entity.getSettleDate()) + "\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u7ed3\u7b97\u65e5\u671f" + DateUtil.formatDate(lastVo.getSettleDate()));
        }
        this.saveOrUpdate((Object)entity, false);
        return (SettleVO)BeanMapper.map((Object)this.selectById(entity.getId()), SettleVO.class);
    }

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public List<RestituteVO> queryRestituteData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(RestituteEntity::getContractId, (Object)contractId);
        wrapper.eq(RestituteEntity::getSettleFlag, (Object)0);
        wrapper.in(RestituteEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(RestituteEntity::getSubmitTime, (Object)settleDate);
        } else {
            wrapper.between(RestituteEntity::getSubmitTime, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.restituteService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<RestituteVO>();
        }
        return BeanMapper.mapList((Iterable)list, RestituteVO.class);
    }

    @Override
    public List<LoseVO> queryLoseData(Long contractId, String lastSettleDate, String settleDate) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LoseEntity::getContractId, (Object)contractId);
        wrapper.eq(LoseEntity::getSettleFlag, (Object)0);
        wrapper.in(LoseEntity::getBillState, Arrays.asList(1, 3));
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (StringUtils.isBlank((CharSequence)lastSettleDate)) {
            wrapper.le(LoseEntity::getSubmitTime, (Object)settleDate);
        } else {
            wrapper.between(LoseEntity::getSubmitTime, (Object)lastSettleDate, (Object)settleDate);
        }
        List list = this.loseService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<LoseVO>();
        }
        return BeanMapper.mapList((Iterable)list, LoseVO.class);
    }

    @Override
    public SettleVO queryLastSettleTaxMny(Long contractId, Long billId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)contractId);
        wrapper.in(SettleEntity::getBillState, Arrays.asList(1, 3));
        if (billId != null) {
            wrapper.ne(BaseEntity::getId, (Object)billId);
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new SettleVO();
        }
        return (SettleVO)BeanMapper.map(list.get(0), SettleVO.class);
    }

    @Override
    public SettleRecordVO querySettleRecord(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(id));
        SettleRecordVO vo = new SettleRecordVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractStatus(entity.getContractStatus());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setSignatureStatus(entity.getSignatureStatus());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SettleEntity::getContractId, (Object)id);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List settleList = super.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)settleList)) {
            vo.setTotalSettleTaxMny(((SettleEntity)((Object)settleList.get(0))).getTotalSettleTaxMny());
            vo.setTotalSettleMny(((SettleEntity)((Object)settleList.get(0))).getTotalSettleMny());
            vo.setSettleRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getTotalSettleTaxMny(), (BigDecimal)vo.getTotalSettleMny()), (BigDecimal)new BigDecimal("100")));
        }
        vo.setDetailList(BeanMapper.mapList((Iterable)settleList, SettleVO.class));
        return vo;
    }

    @Override
    public Boolean pushSettleToPool(SettleVO vo) {
        SettlePoolVO poolVO = new SettlePoolVO();
        try {
            this.logger.info("\u7ed3\u7b97\u5355\u5bf9\u8c61 -> \u7ed3\u7b97\u6c60\u5bf9\u8c61\u81ea\u52a8\u8f6c\u6362\u5f00\u59cb");
            BeanConvertorUtil.convert((Object)vo, (Object)poolVO);
            poolVO.setSourceId(vo.getId());
            poolVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            poolVO.setSourceType(vo.getSettleType());
            poolVO.setSourceTypeName(SettleEnum.getEnumByCode(vo.getSettleType()).getName());
            poolVO.setSettleProperty(Integer.valueOf(SettleEnum.\u652f\u51fa.getCode()));
            poolVO.setSettlePropertyName(SettleEnum.\u652f\u51fa.getName());
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            poolVO.setSupplementFlag(contractEntity.getSupplementFlag());
            poolVO.setMaiContractId(contractEntity.getId());
            poolVO.setMaiContractCode(contractEntity.getBillCode());
            poolVO.setMaiContractName(contractEntity.getContractName());
            poolVO.setSignDate(contractEntity.getSignDate());
            poolVO.setCreateTime(vo.getCreateTime());
            poolVO.setCreateUserCode(vo.getCreateUserCode());
            poolVO.setUpdateTime(vo.getUpdateTime());
            poolVO.setUpdateUserCode(vo.getUpdateUserCode());
            CommonResponse res = this.settlePoolApi.saveOrUpdateSettle(poolVO);
            if (res.isSuccess()) {
                this.logger.info("\u7ed3\u7b97\u5355\u63a8\u9001\u81f3\u7ed3\u7b97\u6c60\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId());
                return true;
            }
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)vo.getId(), (Object)res.getMsg());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u7b97\u5355\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}", (Object)vo.getId(), (Object)e);
        }
        return false;
    }

    @Override
    public Boolean delSettleFromPool(Long id) {
        SettlePoolVO poolVO = new SettlePoolVO();
        poolVO.setSourceId(id);
        CommonResponse res = this.settlePoolApi.deleteSettle(poolVO);
        if (res.isSuccess()) {
            this.logger.info("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u6210\u529f\uff01\u7ed3\u7b97\u5355id-{}", (Object)id);
            return true;
        }
        this.logger.error("\u5c06\u7ed3\u7b97\u5355\u4ece\u7ed3\u7b97\u6c60\u4e2d\u5220\u9664\u5931\u8d25\uff01\u7ed3\u7b97\u5355id-{}\uff0c{}", (Object)id, (Object)res.getMsg());
        return false;
    }
}

