package com.ejianc.business.assist.rmat.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 遗失单
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("lose")
public class LoseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSISTRMAT_LOSE";//此处需要根据实际修改

    @Autowired
    private ILoseService service;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IContractNumRentService numRentService;
    @Autowired
    private IContractDailyRentService dailyRentService;
    @Autowired
    private IContractMonthRentService monthRentService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IRmatFlowService flowService;

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/assistrmat/lose/card";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LoseVO> saveOrUpdate(@RequestBody LoseVO saveOrUpdateVO) {
        // 同一个合同只能存在一个自由态或审批中的单据
        materialService.validateContract(saveOrUpdateVO.getContractId(), MaterialConstant.遗失单, saveOrUpdateVO.getId(), MaterialConstant.保存);
        // 校验必须大于最大单据日期
        service.validateTime(saveOrUpdateVO, MaterialConstant.保存);
        validateNum(saveOrUpdateVO);
    	LoseEntity entity = BeanMapper.map(saveOrUpdateVO, LoseEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 汇总材料分类
        List<LoseDetailVO> detailList = saveOrUpdateVO.getLoseDetailList();
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) &&
                StringUtils.isNotEmpty(x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);

        service.saveOrUpdate(entity, false);
        // 推送流水未生效
        if(!flowService.insertLoseFlow(entity, BillTypeEnum.遗失单.getCode(), RmatCommonConsts.NO)){
            return CommonResponse.error("单据推送流水失败！");
        }
    	LoseVO vo = BeanMapper.map(entity, LoseVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 校验数量不能大于可参照数量
     * @param loseVO
     * @return
     */
    private String validateNum(LoseVO loseVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, loseVO.getContractId()));
        List<MaterialVO> list = materialService.queryCheckList(param, "lose");
        Map<String, MaterialVO> map = list.stream().collect(Collectors.toMap(x->x.getMaterialId() + "|" + x.getRentCalculationType(), Function.identity()));
        String key = null;
        for(LoseDetailVO vo : loseVO.getLoseDetailList()){
            key = vo.getMaterialId() + "|" + vo.getRentCalculationType();
            if(map.containsKey(key) && vo.getLoseNum().compareTo(map.get(key).getRefNum()) > 0){
                throw new BusinessException("子表数量大于可参照数量");
            }
        }
        return "校验通过！";
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LoseVO> queryDetail(Long id) {
    	LoseEntity entity = service.selectById(id);
    	LoseVO vo = BeanMapper.map(entity, LoseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoseVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (LoseVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(LoseVO::getId).collect(Collectors.toList());
        // 删除流水
        if(!flowService.delFlow(ids, BillTypeEnum.遗失单.getCode())){
            return CommonResponse.error("单据删除流水失败！");
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialTypeNames");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<LoseEntity> page = service.queryPage(param,false);
        IPage<LoseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<LoseVO> loseVOS = BeanMapper.mapList(page.getRecords(), LoseVO.class);
        loseVOS.forEach(e -> {
            if (e.getSupplierSignStatus()==1){
                e.setSupplierSignStatusName("已签字");
            }else{
                e.setSupplierSignStatusName("未签字");
            }
        });
        pageData.setRecords(loseVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<LoseEntity> list = service.queryList(param);
        List<LoseVO> loseVOS = BeanMapper.mapList(list, LoseVO.class);
        loseVOS.forEach(e -> {
            if (e.getSupplierSignStatus()==1){
                e.setSupplierSignStatusName("已签字");
            }else{
                e.setSupplierSignStatusName("未签字");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", loseVOS);
        ExcelExport.getInstance().export("Lose-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refLoseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LoseVO>> refLoseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<LoseEntity> page = service.queryPage(param,false);
        IPage<LoseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LoseVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validateContract 校验合同下是否存在未生效单据
     * @param contractId 合同ID
     * @param billId 单据主键
     */
    @RequestMapping(value = "/validateContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam("contractId") Long contractId,
                                                   @RequestParam(value = "billId", required = false) Long billId) {
        String msg = service.validateContract(contractId, billId);
        return CommonResponse.success("校验成功！", msg);
    }
    //获取遗失单价税率
    @RequestMapping(value = "/getLosePrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> getLosePrice(@RequestBody List<MaterialVO> vos) {
        List<Map<String,Object>> list = new ArrayList<>();
        vos.forEach(e->{
            if ("0".equals(e.getRentCalculationType())){
                QueryWrapper<ContractDailyRentEntity> query = new QueryWrapper<>();
                query.select("material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice");
                query.eq("dr",0);
                query.eq("tenant_id", InvocationInfoProxy.getTenantid());
                query.eq("material_id",e.getMaterialId());
                List<Map<String,Object>> map = dailyRentService.listMaps(query);
                list.addAll(map);
            }else if ("1".equals(e.getRentCalculationType())){
                QueryWrapper<ContractMonthRentEntity> query = new QueryWrapper<>();
                query.select("material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice");
                query.eq("dr",0);
                query.eq("tenant_id", InvocationInfoProxy.getTenantid());
                query.eq("material_id",e.getMaterialId());
                List<Map<String,Object>> map = monthRentService.listMaps(query);
                list.addAll(map);
            }else {
                QueryWrapper<ContractNumRentEntity> query = new QueryWrapper<>();
                query.select("material_id as materialId,lose_unit_tax_price as loseUnitTaxPrice,tax_rate as taxRate,lose_unit_price as loseUnitPrice");
                query.eq("dr",0);
                query.eq("tenant_id", InvocationInfoProxy.getTenantid());
                query.eq("material_id",e.getMaterialId());
                List<Map<String,Object>> map = numRentService.listMaps(query);
                list.addAll(map);
            }
        });
        return CommonResponse.success(list);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @GetMapping(value = "/testPushBill")
    public CommonResponse<String> testPushBill(Long id) {
        LoseEntity entity = service.selectById(id);
        service.pushBillToSupCenter(entity);
        return CommonResponse.success("推送成功！");
    }

    @GetMapping(value = "/getBillShareLink")
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        LoseEntity entity = service.selectById(id);
        if(SupplierSignStatusEnum.乙方未签字.getCode().equals(entity.getSupplierSignStatus())
                && BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //未曾成功推送单据，则先向供方推送单据
            boolean pushResult = service.pushBillToSupCenter(entity);
            if(!pushResult) {
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                service.saveOrUpdate(entity, false);
            }
        }
        return shareCooperateApi.getShareLink(id, BillTypeEnum.遗失单.getCode(), entity.getSupplierId().toString(),
                mobileBillShareFrontUrl, null);
    }
}
