package com.ejianc.business.assist.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.assist.rmat.bean.LoseDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 遗失单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_assistrmat_lose")
public class LoseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="contract_id")
    private Long contractId; // 合同ID
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="stop_date")
    private Date stopDate; // 止租日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 部门
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供方主键
    @TableField(value="supplier_name")
    private String supplierName; // 供方名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="confirm_state")
    private String confirmState; // 是否确认
    @TableField(value="supplier_sign_status")
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    @TableField(value="sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(value="bill_date")
    private Date billDate; // 经办日期
    @TableField(value="material_type_names")
    private String materialTypeNames; // 材料分类
    @TableField(exist = false)
    private Long supOperateFileId;// 供方经办人签字文件id
    @TableField(exist = false)
    private String sourceSystemId;// 来源业务系统id
    @TableField(value="first_party_id")
    private Long firstPartyId;//甲方Id
    @TableField(value="first_party_name")
    private String firstPartyName;//甲方名称
    @TableField(value = "bill_push_flag")
    private String billPushFlag;// 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value = "submit_time")
    private Date submitTime;//单据提交时间
    @TableField(value = "settle_flag")
    private Integer settleFlag;//是否结算
    @TableField(value = "total_lose_tax")
    private BigDecimal totalLoseTax;
    @TableField(value="total_compensation_mny")
    private BigDecimal totalCompensationMny; // 赔偿金额汇总(无税)
    @TableField(value="compensation_tax_mny")
    private BigDecimal compensationTaxMny; // 赔偿金额汇总
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率

    @TableField(exist=false)
    @SubEntity(serviceName="loseDetailService",pidName = "loseId")
    private List<LoseDetailEntity> loseDetailList = new ArrayList<>(); // 遗失单材料清单明细

    @TableField(exist=false)
    @SubEntity(serviceName="loseOtherService",pidName = "loseId")
    private List<LoseOtherEntity> loseOtherList = new ArrayList<>(); // 遗失单材料清单明细

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getStopDate() {
        return stopDate;
    }

    public void setStopDate(Date stopDate) {
        this.stopDate = stopDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getConfirmState() {
        return confirmState;
    }

    public void setConfirmState(String confirmState) {
        this.confirmState = confirmState;
    }
    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getSourceSystemId() {
        return sourceSystemId;
    }

    public void setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
    }

    public BigDecimal getCompensationTaxMny() {
        return compensationTaxMny;
    }

    public void setCompensationTaxMny(BigDecimal compensationTaxMny) {
        this.compensationTaxMny = compensationTaxMny;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Date getSubmitTime() {
        return submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public BigDecimal getTotalLoseTax() {
        return totalLoseTax;
    }

    public BigDecimal getTotalCompensationMny() {
        return totalCompensationMny;
    }

    public void setTotalCompensationMny(BigDecimal totalCompensationMny) {
        this.totalCompensationMny = totalCompensationMny;
    }

    public void setTotalLoseTax(BigDecimal totalLoseTax) {
        this.totalLoseTax = totalLoseTax;
    }

    public List<LoseDetailEntity> getLoseDetailList() {
        return loseDetailList;
    }

    public void setLoseDetailList(List<LoseDetailEntity> loseDetailList) {
        this.loseDetailList = loseDetailList;
    }

    public List<LoseOtherEntity> getLoseOtherList() {
        return loseOtherList;
    }

    public void setLoseOtherList(List<LoseOtherEntity> loseOtherList) {
        this.loseOtherList = loseOtherList;
    }
}
