package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.consts.RmatCommonConsts;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.mapper.MaterialMapper;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.utils.ListCallable;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.assist.rmat.vo.CheckDetailVO;
import com.ejianc.business.assist.rmat.vo.CheckVO;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.business.assist.rmat.vo.MaxTimeVO;
import com.ejianc.business.common.CommonConstant;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 材料公共接口
 * 
 * @author generator
 * 
 */
@Service("materialService")
public class MaterialServiceImpl implements IMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;

    @Autowired
    private IStartService startService;

    @Autowired
    private IStopService stopService;

    @Autowired
    private IRestituteService restService;

    @Autowired
    private ILoseService loseService;

    @Autowired
    private IRentCalculateService rentService;

    @Autowired
    private MaterialMapper baseMapper;

    @Autowired
    private IRmatFlowService flowService;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        if("report".equals(type)){
            param.getFuzzyFields().add("contractName");
            param.getFuzzyFields().add("supplierName");
            param.getFuzzyFields().add("billCode");
        }
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List<RmatFlowEntity> flowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        List<RmatFlowEntity> tempRestList = new ArrayList<>();// 未生效退赔单
        List<RmatFlowEntity> tempLoseList = new ArrayList<>();// 未生效遗失单
        for(RmatFlowEntity flow : flowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.验收单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.退赔单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.遗失单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
            if(RmatCommonConsts.NO.equals(flow.getEffectiveState())){
                if(BillTypeEnum.退赔单.getCode().equals(flow.getBillTypeCode())){
                    tempRestList.add(flow);
                }
                if(BillTypeEnum.遗失单.getCode().equals(flow.getBillTypeCode())){
                    tempLoseList.add(flow);
                }
            }
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+计组方式+使用状态+转换系数，value-物料
        String key = null;
        for(RmatFlowEntity detail: checkList){// 验收单
            for(int i = 0; i< 2; i++){// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                MaterialVO vo = new MaterialVO();
                if(!map.containsKey(key)){
                    vo.setId(key);
                    // 转换材料明细信息
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = map.get(key);
                }
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                // 辅数量
                vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                map.put(key, vo);
            }
        }
        for(RmatFlowEntity detail: startList){// 启用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用 = 已停用 - 已启用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 - 启用单辅数量
                    vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
                } else {// 已启用
                    vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 + 启用单辅数量
                    vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                }
            }
        }
        for(RmatFlowEntity detail: stopList){// 停用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + i + "|" + detail.getTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用
                    vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 + 停用单辅数量
                    vo.setAssistNum(ComputeUtil.safeAdd(vo.getAssistNum(), detail.getAssistNum()));
                } else {
                    // 已启用 = 已启用 - 已停用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 - 停用单辅数量
                    vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
                }
            }
        }
        for(RmatFlowEntity detail: restList){
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 退赔单辅数量
            vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 遗失单辅数量
            vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
        }
        for(RmatFlowEntity detail : tempRestList){// 未生效退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempRestNum(ComputeUtil.safeAdd(vo.getTempRestNum(), detail.getNum()));
            if("lose".equals(type)){
                // 辅数量 = 辅数量 - 未生效退赔单辅数量
                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
            }
        }
        for(RmatFlowEntity detail : tempLoseList){// 未生效遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentCalculationType() + "|" + detail.getUseStatus() + "|" + detail.getTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempLoseNum(ComputeUtil.safeAdd(vo.getTempLoseNum(), detail.getNum()));
            if("rest".equals(type)){
                // 辅数量 = 辅数量 - 未生效遗失单辅数量
                vo.setAssistNum(ComputeUtil.safeSub(vo.getAssistNum(), detail.getAssistNum()));
            }
        }
        for(Iterator<MaterialVO> it = map.values().iterator(); it.hasNext();){
            MaterialVO vo = it.next();
            switch(type){
                case "start":// 在场可启用数量 = 已停用 - 已退赔 - 已遗失
                    if("1".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "stop":// 在场可停用数量 = 已启用 - 已退赔 - 已遗失
                    if("0".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "rest":
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    break;
                case "lose":
                    if("0".equals(vo.getUseStatus())){// 可遗失数量 = 已停用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可遗失数量 = 已启用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    break;
                case "report":
                    if("0".equals(vo.getUseStatus())){// 在场停用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 在场启用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    break;
                default:
                    break;
            }
            vo.setNumM(vo.getRefNum());// 可参照主数量记录
            // 在场材料档案的可参照数量使用辅数量，台账的在场数量使用主数量
            if(!"report".equals(type)){
                vo.setRefNum(vo.getAssistNum());
            }
            // 过滤数量小于0
            if(vo.getRefNum() == null || vo.getRefNum().compareTo(BigDecimal.ZERO) <= 0){
                it.remove();
                continue;
            }
        }
        return new ArrayList<>(map.values());
    }

    /**
     * 转换材料明细信息
     * @param detail
     * @param vo
     */
    private void transferVO(RmatFlowEntity detail, MaterialVO vo) {
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgCode(detail.getOrgCode());
        vo.setOrgName(detail.getOrgName());
        vo.setParentOrgId(detail.getParentOrgId());
        vo.setParentOrgCode(detail.getParentOrgCode());
        vo.setParentOrgName(detail.getParentOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());

        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setAssistUnitId(detail.getAssistUnitId());
        vo.setAssistUnitName(detail.getAssistUnitName());
        vo.setTransScale(detail.getTransScale());
        vo.setRentCalculationType(detail.getRentCalculationType());
        vo.setRentTypeName("2".equals(detail.getRentCalculationType()) ? "工程量租" :
                "1".equals(detail.getRentCalculationType()) ? "月租" :
                "0".equals(detail.getRentCalculationType()) ? "日租" : null);

        vo.setContractRmatMethod(detail.getContractRmatMethod());
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(6);
        QueryParam param = Utils.deepCopy(queryParam);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.验收单.equals(billType) ? param : queryParam, checkService);// 验收单
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.启用单.equals(billType) ? param : queryParam, startService);// 启用单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.停用单.equals(billType) ? param : queryParam, stopService);// 停用单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.退赔单.equals(billType) ? param : queryParam, restService);// 退赔单
        Future<JSONArray> future5 = ListCallable.excute(threadPool, MaterialConstant.遗失单.equals(billType) ? param : queryParam, loseService);// 遗失单
        Future<JSONArray> future6 = ListCallable.excute(threadPool, MaterialConstant.租金计算单.equals(billType) ? param : queryParam, rentService);// 租金计算单

        List<CheckEntity> checkList = new ArrayList<>();// 验收单
        List<StartEntity> startList = new ArrayList<>();// 启用单
        List<StopEntity> stopList = new ArrayList<>();// 停用单
        List<RestituteEntity> restList = new ArrayList<>();// 退赔单
        List<LoseEntity> loseList = new ArrayList<>();// 遗失单
        List<RentCalculateEntity> rentList = new ArrayList<>();// 租金计算单
        try {
            checkList = JSONObject.parseArray(future1.get().toJSONString(), CheckEntity.class);
            startList = JSONObject.parseArray(future2.get().toJSONString(), StartEntity.class);
            stopList = JSONObject.parseArray(future3.get().toJSONString(), StopEntity.class);
            restList = JSONObject.parseArray(future4.get().toJSONString(), RestituteEntity.class);
            loseList = JSONObject.parseArray(future5.get().toJSONString(), LoseEntity.class);
            rentList = JSONObject.parseArray(future6.get().toJSONString(), RentCalculateEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(CollectionUtils.isNotEmpty(checkList)){
            throw new BusinessException("当前合同存在非审批通过态的验收单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(startList)){
            throw new BusinessException("当前合同存在非审批通过态的启用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(stopList)){
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(restList)){
            throw new BusinessException("当前合同存在非审批通过态的退赔单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(loseList)){
            throw new BusinessException("当前合同存在非审批通过态的遗失单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(rentList)){
            throw new BusinessException("当前合同存在非审批通过态的租金计算单，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        return list.stream().filter(x->x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String type = "report";// start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账

        // 使用状态(启用、停用)
        Parameter useStatusParameter = param.getParams().get("useStatus");
        List<String> useStatusList = new ArrayList<>();
        if(useStatusParameter != null && useStatusParameter.getValue() != null){
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        // 租赁方式(内租、外租)
        Parameter contractRmatMethodParameter = param.getParams().get("contractRmatMethod");
        List<String> contractRmatMethodList = new ArrayList<>();
        if(contractRmatMethodParameter != null && contractRmatMethodParameter.getValue() != null){
            String contractRmatMethod = (String)contractRmatMethodParameter.getValue();
            String[] split = contractRmatMethod.split(",");
            contractRmatMethodList = Arrays.asList(split);
            param.getParams().remove("contractRmatMethod");
        }
        // 计租方式(日租、月租、工程量租)
        Parameter rentCalculationTypeParameter = param.getParams().get("rentCalculationType");
        List<String> rentCalculationTypeList = new ArrayList<>();
        if(rentCalculationTypeParameter != null && rentCalculationTypeParameter.getValue() != null){
            String rentCalculationType = (String)rentCalculationTypeParameter.getValue();
            String[] split = rentCalculationType.split(",");
            rentCalculationTypeList = Arrays.asList(split);
            param.getParams().remove("rentCalculationType");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);

        List<MaterialVO> resList = new ArrayList<>();
        for(MaterialVO vo : list){
            boolean flag = false;
            if(useStatusList.size()>0 && !useStatusList.contains(vo.getUseStatus())){
                flag = true;
            }
            if(contractRmatMethodList.size()>0 && !contractRmatMethodList.contains(vo.getContractRmatMethod())){
                flag = true;
            }
            if(rentCalculationTypeList.size()>0 && !rentCalculationTypeList.contains(vo.getRentCalculationType())){
                flag = true;
            }
            if(!flag){
                resList.add(vo);
            }
        }
        resList.forEach(vo -> {
            if (null != vo.getContractRmatMethod()) {
                if ("0".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("外租");
                } else if ("1".equals(vo.getContractRmatMethod())) {
                    vo.setContractRmatMethodName("内租");
                }
            } else {
                vo.setContractRmatMethodName("");
            }
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("停用");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("启用");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }

    @Override
    public String validateCheckDetail(CheckVO vo) {
        List<CheckDetailVO> detailList = vo.getCheckDetailList();

        if (CollectionUtils.isNotEmpty(detailList)){
            Boolean checkNumsSum = true;
            Boolean transScale = true;
            Boolean transScaleSecond = true;
            Boolean passMuster = true;
            for (CheckDetailVO detailVO : detailList){
                if (null == detailVO.getCheckNumsSum()){
                    checkNumsSum = false;
                }
                if (null == detailVO.getTransScale()){
                    transScale = false;
                }
                if (CommonConstant.YES_STR.equals(vo.getLoadometerWeight())){
                    if (null == detailVO.getTransScaleSecond()){
                        transScaleSecond = false;
                    }
                    if (CommonConstant.NO_STR.equals(detailVO.getPassMuster())){
                        passMuster = false;
                    }
                }
                if (!checkNumsSum){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】验收数量不能为空！");
                }
                if (!transScale){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】转换系数未设置，无法计算计量数量！");
                }
                if (!transScaleSecond){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】转换系数未设置，无法计算理论重量！");
                }
                if (!passMuster){
                    throw new BusinessException("【"+detailVO.getMaterialName()+"】净值与理论重量不符合要求！");
                }

            }
        }


        return "校验通过！";
    }



}
