/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.rmat.service.IMaterialService;
import com.ejianc.business.assist.rmat.utils.PageUtil;
import com.ejianc.business.assist.rmat.vo.MaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"material"})
public class MaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialService service;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/refMaterialData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> refMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String type = "report";
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (condition.contains("type")) {
                type = json.getString("type");
            }
            if (condition.contains("contractId")) {
                param.getParams().put("contractId", new Parameter("eq", (Object)json.getString("contractId")));
            }
        }
        List<MaterialVO> list = this.service.queryCheckList(param, type);
        List<MaterialVO> records = PageUtil.listToPage(list, pageNumber, pageSize);
        Page page = new Page();
        page.setRecords(records);
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        page.setTotal((long)list.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billType", required=false) String billType, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billType, billId, "\u4fdd\u5b58");
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/getLastDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> getLastDate(@RequestParam(required=false) Map<String, Object> params) {
        Date date = this.service.getLastDate(params);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)date);
    }

    @RequestMapping(value={"/proMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> proMaterialList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List<MaterialVO> resList = this.service.proMaterialList(param);
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        List<MaterialVO> records = PageUtil.listToPage(resList, pageNumber, pageSize);
        Page page = new Page();
        page.setRecords(records);
        page.setCurrent((long)pageNumber);
        page.setSize((long)pageSize);
        page.setTotal((long)resList.size());
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u5468\u8f6c\u6750\u53f0\u8d26\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List<MaterialVO> resList = this.service.proMaterialList(param);
        HashMap<String, List<MaterialVO>> beans = new HashMap<String, List<MaterialVO>>();
        beans.put("records", resList);
        ExcelExport.getInstance().export("proMaterialList-export.xlsx", beans, response);
    }
}

