package com.ejianc.business.assist.ownrmat.service.impl;

import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.rmat.utils.MaterialConstant;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.assist.ownrmat.vo.HandleVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("handle") 
public class HandleBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IHandleService service;

	@Autowired
	private IStoreManageApi storeManageApi;

	@Autowired
	private IValidateService validateService;

	@Autowired
	private HandleServiceImpl handleService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		HandleEntity handleEntity = service.selectById(billId);
		HandleVO handleVO = BeanMapper.map(handleEntity, HandleVO.class);
		validateService.validateHandle(handleVO);
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		HandleEntity outStoreEntity = service.selectById(billId);
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getProjectId());
		storeManageVO.setSourceId(outStoreEntity.getId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
		storeManageVO.setOutEffectiveON(true);
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
		outStoreEntity.getHandleSubList().forEach(t->{
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.周转材材料处置, 0);
			flowVO.setStoreId(outStoreEntity.getProjectId());
			flowVO.setStoreName(outStoreEntity.getProjectName());
			flowVO.setProjectId(outStoreEntity.getProjectId());
			flowVO.setProjectName(outStoreEntity.getProjectName());
			flowVO.setOrgId(outStoreEntity.getOrgId());
			flowVO.setOrgName(outStoreEntity.getOrgName());
			flowVO.setParentOrgId(outStoreEntity.getParentOrgId());
			flowVO.setParentOrgName(outStoreEntity.getParentOrgName());
			flowVO.setEmployeeId(outStoreEntity.getEmployeeId());
			flowVO.setEmployeeName(outStoreEntity.getEmployeeName());
			flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
			flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
			flowVO.setMaterialId(t.getMaterialId());
			flowVO.setMaterialName(t.getMaterialName());
			flowVO.setMaterialSpec(t.getSpec());
			flowVO.setMaterialUnitId(t.getUnit());
			flowVO.setMaterialUnitName(t.getUnitName());
			flowVO.setSourceBillDetailRemark(t.getMemo());
			flowVO.setTaxPrice(t.getHandleTaxPrice());
			flowVO.setPrice(t.getHandlePrice());
			flowVO.setNum(t.getHandleNum());
			flowVO.setTaxMny(t.getHandleTaxMny());
			flowVO.setMny(t.getHandleMny());
			flowVO.setTax(t.getTax());
			flowVO.setSourceId(outStoreEntity.getId());
			flowVO.setSourceDetailId(t.getId());
			flowVO.setSourceBillCode(outStoreEntity.getBillCode());
			flowVO.setSourceBillDate(outStoreEntity.getHandleDate());
			flowVO.setRowState(t.getRowState());
			flowVO.setSourceBillRemark(outStoreEntity.getHandleReason());
			flowVOS.add(flowVO);
		});
		storeManageVO.setFlowVOList(flowVOS);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		HandleEntity outStoreEntity = service.selectById(billId);
		// 同一个合同只能存在一个自由态或审批中的单据
		validateService.validateProject(outStoreEntity.getProjectId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		handleService.validateTime(BeanMapper.map(outStoreEntity, HandleVO.class), MaterialConstant.弃审);
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getProjectId());
		storeManageVO.setSourceIdsForRollBack(ids);
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.周转材材料处置);
		storeManageVO.setOutEffectiveON(true);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}else{
			return CommonResponse.success();
		}
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

}
