/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.assist.ownrmat.bean.HandleDetailEntity;
import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.mapper.HandleMapper;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.vo.HandleVO;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="handleService")
public class HandleServiceImpl
extends BaseServiceImpl<HandleMapper, HandleEntity>
implements IHandleService {
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IStoreManageApi storeManageApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "PRO_RMAT_HANDLE";
    @Autowired
    private IValidateService validateService;

    @Override
    public CommonResponse<HandleVO> saveOrUpdate(HandleVO handleVO) {
        this.validateService.validateProject(handleVO.getProjectId(), "\u5468\u8f6c\u6750\u5904\u7f6e", handleVO.getId(), "\u4fdd\u5b58");
        this.validateTime(handleVO, "\u4fdd\u5b58");
        HandleEntity entity = (HandleEntity)((Object)BeanMapper.map((Object)handleVO, HandleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)handleVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ArrayList<HandleDetailEntity> subList = new ArrayList<HandleDetailEntity>();
        List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
        String names = "";
        for (HandleDetailEntity detailEntity : handleSubList) {
            if (detailEntity.getHandleNum() != null && detailEntity.getHandleNum().compareTo(BigDecimal.ZERO) > 0) {
                subList.add(detailEntity);
            }
            names = names + detailEntity.getMaterialCategoryName() + ",";
        }
        if (handleSubList.size() > 0) {
            names = names.substring(0, names.length() - 1);
        }
        entity.setMaterialTypes(names);
        super.saveOrUpdate((Object)entity, false);
        if (handleVO.getHandleSubList().size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(handleVO.getProjectId());
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
            ArrayList flowVOS = new ArrayList();
            handleVO.getHandleSubList().forEach(t -> {
                if ("del".equals(t.getRowState())) {
                    FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
                    flowVO.setStoreId(handleVO.getStoreId());
                    flowVO.setStoreName(handleVO.getStoreName());
                    flowVO.setProjectId(entity.getProjectId());
                    flowVO.setProjectName(entity.getProjectName());
                    flowVO.setOrgId(entity.getOrgId());
                    flowVO.setOrgName(entity.getOrgName());
                    flowVO.setParentOrgId(entity.getParentOrgId());
                    flowVO.setParentOrgName(entity.getParentOrgName());
                    flowVO.setEmployeeId(handleVO.getEmployeeId());
                    flowVO.setEmployeeName(handleVO.getEmployeeName());
                    flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                    flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                    flowVO.setMaterialId(t.getMaterialId());
                    flowVO.setMaterialName(t.getMaterialName());
                    flowVO.setMaterialSpec(t.getSpec());
                    flowVO.setMaterialUnitId(t.getUnit());
                    flowVO.setMaterialUnitName(t.getUnitName());
                    flowVO.setSourceBillDetailRemark(t.getMemo());
                    flowVO.setTaxPrice(t.getHandleTaxPrice());
                    flowVO.setPrice(t.getHandlePrice());
                    flowVO.setNum(t.getHandleNum());
                    flowVO.setTaxMny(t.getHandleTaxMny());
                    flowVO.setMny(t.getHandleMny());
                    flowVO.setTax(t.getTax());
                    flowVO.setSourceId(entity.getId());
                    flowVO.setSourceDetailId(t.getId());
                    flowVO.setSourceBillCode(entity.getBillCode());
                    flowVO.setSourceBillDate(entity.getHandleDate());
                    flowVO.setRowState(t.getRowState());
                    flowVO.setSourceBillRemark(entity.getHandleReason());
                    flowVO.setPurchasePrice(t.getOriginalValuePrice());
                    flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                    flowVOS.add(flowVO);
                }
            });
            entity.getHandleSubList().forEach(t -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
                flowVO.setStoreId(entity.getStoreId());
                flowVO.setStoreName(entity.getStoreName());
                flowVO.setProjectId(entity.getProjectId());
                flowVO.setProjectName(entity.getProjectName());
                flowVO.setOrgId(entity.getOrgId());
                flowVO.setOrgName(entity.getOrgName());
                flowVO.setParentOrgId(entity.getParentOrgId());
                flowVO.setParentOrgName(entity.getParentOrgName());
                flowVO.setEmployeeId(entity.getEmployeeId());
                flowVO.setEmployeeName(entity.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getSpec());
                flowVO.setMaterialUnitId(t.getUnit());
                flowVO.setMaterialUnitName(t.getUnitName());
                flowVO.setSourceBillDetailRemark(t.getMemo());
                flowVO.setTaxPrice(t.getHandleTaxPrice());
                flowVO.setPrice(t.getHandlePrice());
                flowVO.setNum(t.getHandleNum());
                flowVO.setTaxMny(t.getHandleTaxMny());
                flowVO.setMny(t.getHandleMny());
                flowVO.setTax(t.getTax());
                flowVO.setSourceId(entity.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(entity.getBillCode());
                flowVO.setSourceBillDate(entity.getHandleDate());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceBillRemark(entity.getHandleReason());
                flowVO.setPurchasePrice(t.getOriginalValuePrice());
                flowVO.setPurchaseTaxPrice(t.getOriginalValueTaxPrice());
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
            this.logger.debug("\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
        }
        HandleVO vo = (HandleVO)BeanMapper.map((Object)((Object)entity), HandleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public String validateTime(HandleVO handleVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", handleVO.getProjectId());
        if (handleVO.getId() != null) {
            params.put("billType", "\u9057\u5931\u5355");
            params.put("billId", handleVO.getId());
        }
        Date lastDate = this.validateService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.validateService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(handleVO.getHandleDate(), lastDate, maxTimeMap, handleVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(handleVO.getHandleDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CommonResponse myRemoveByIds(List<Long> ids) {
        CommonResponse commonResponse = this.handleInOut(ids, false);
        if (!commonResponse.isSuccess()) {
            return commonResponse;
        }
        super.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse handleInOut(List<Long> ids, Boolean outEffectiveON) {
        StoreManageVO storeManageVO = new StoreManageVO();
        ArrayList<Long> SourceIds = new ArrayList<Long>();
        for (Long item : ids) {
            HandleEntity entity = (HandleEntity)((Object)super.selectById((Serializable)item));
            List<HandleDetailEntity> handleSubList = entity.getHandleSubList();
            Boolean checkFlag = false;
            for (HandleDetailEntity t : handleSubList) {
                if (t.getHandleNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                checkFlag = true;
                break;
            }
            if (!checkFlag.booleanValue()) continue;
            SourceIds.clear();
            SourceIds.add(item);
            storeManageVO.setSourceId(item);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
            storeManageVO.setSourceIdsForRollBack(SourceIds);
            storeManageVO.setOutEffectiveON(outEffectiveON);
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (response.isSuccess()) continue;
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
        }
        return CommonResponse.success();
    }
}

