package com.ejianc.business.assist.rmat.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态
 */
public enum ContractStatusEnum {
    /**
     * 合同履约状态：1、未签订；
     */
    未签订("0", "未签订"),

    /**
     * 合同履约状态：2、履约中；
     */
    履约中("1", "履约中"),

    /**
     * 合同履约状态：3、已封账；
     */
    已封账("2", "已封账"),

    /**
     * 合同履约状态：4、已解除；
     */
    已解除("3", "已解除"),
    /**
     * 合同履约状态
     */
    已冻结("4", "已冻结");



    private String code;
    private String description;
    private static Map<String, ContractStatusEnum> enumMap = new HashMap<>();

    ContractStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ContractStatusEnum.class).stream().collect(Collectors.toMap(ContractStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractStatusEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
