/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.service.impl.HandleServiceImpl;
import com.ejianc.business.assist.ownrmat.vo.HandleVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="handle")
public class HandleBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IHandleService service;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IValidateService validateService;
    @Autowired
    private HandleServiceImpl handleService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity handleEntity = (HandleEntity)((Object)this.service.selectById(billId));
        HandleVO handleVO = (HandleVO)BeanMapper.map((Object)((Object)handleEntity), HandleVO.class);
        this.validateService.validateHandle(handleVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity outStoreEntity = (HandleEntity)((Object)this.service.selectById(billId));
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreEntity.getProjectId());
        storeManageVO.setSourceId(outStoreEntity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        ArrayList flowVOS = new ArrayList();
        outStoreEntity.getHandleSubList().forEach(t -> {
            FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e, (Integer)0);
            flowVO.setStoreId(outStoreEntity.getProjectId());
            flowVO.setStoreName(outStoreEntity.getProjectName());
            flowVO.setProjectId(outStoreEntity.getProjectId());
            flowVO.setProjectName(outStoreEntity.getProjectName());
            flowVO.setOrgId(outStoreEntity.getOrgId());
            flowVO.setOrgName(outStoreEntity.getOrgName());
            flowVO.setParentOrgId(outStoreEntity.getParentOrgId());
            flowVO.setParentOrgName(outStoreEntity.getParentOrgName());
            flowVO.setEmployeeId(outStoreEntity.getEmployeeId());
            flowVO.setEmployeeName(outStoreEntity.getEmployeeName());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getSpec());
            flowVO.setMaterialUnitId(t.getUnit());
            flowVO.setMaterialUnitName(t.getUnitName());
            flowVO.setSourceBillDetailRemark(t.getMemo());
            flowVO.setTaxPrice(t.getHandleTaxPrice());
            flowVO.setPrice(t.getHandlePrice());
            flowVO.setNum(t.getHandleNum());
            flowVO.setTaxMny(t.getHandleTaxMny());
            flowVO.setMny(t.getHandleMny());
            flowVO.setTax(t.getTax());
            flowVO.setSourceId(outStoreEntity.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(outStoreEntity.getBillCode());
            flowVO.setSourceBillDate(outStoreEntity.getHandleDate());
            flowVO.setRowState(t.getRowState());
            flowVO.setSourceBillRemark(outStoreEntity.getHandleReason());
            flowVOS.add(flowVO);
        });
        storeManageVO.setFlowVOList(flowVOS);
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        HandleEntity outStoreEntity = (HandleEntity)((Object)this.service.selectById(billId));
        this.validateService.validateProject(outStoreEntity.getProjectId(), null, null, "\u5f03\u5ba1");
        this.handleService.validateTime((HandleVO)BeanMapper.map((Object)((Object)outStoreEntity), HandleVO.class), "\u5f03\u5ba1");
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setStoreId(outStoreEntity.getProjectId());
        storeManageVO.setSourceIdsForRollBack(ids);
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u5468\u8f6c\u6750\u6750\u6599\u5904\u7f6e);
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg()));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

