package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.*;
import com.ejianc.business.assist.rmat.enums.BillPushStatusEnum;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.enums.ContractStatusEnum;
import com.ejianc.business.assist.rmat.enums.SettleEnum;
import com.ejianc.business.assist.rmat.service.*;
import com.ejianc.business.assist.rmat.vo.SettleVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("settle") 
public class SettleBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private ISettleService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IRentCalculateService calculateService;
	
	@Autowired
	private IRestituteService restituteService;

	@Autowired
	private ILoseService loseService;

	@Autowired
	private IContractService contractService;

	@Autowired
	private IExecutionApi executionApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		
		SettleEntity settleEntity = service.selectById(billId);

		UserContext userContext = sessionManager.getUserContext();

		LambdaUpdateWrapper<SettleEntity> wrapper = new LambdaUpdateWrapper<>();
		wrapper.set(SettleEntity::getCommitDate, new Date());
		wrapper.set(SettleEntity::getCommitUserCode, userContext.getUserCode());
		wrapper.set(SettleEntity::getCommitUserName, userContext.getUserName());

		
		ContractEntity contractEntity = contractService.getById(settleEntity.getContractId());

		if (Objects.equals(settleEntity.getSettleType(), "1")) {
			// 最终结算回写合同状态为已终止
			contractEntity.setContractStatus(ContractStatusEnum.已封账.getCode());
			contractService.save(contractEntity);
		}
		
		// 回写引用单据结算状态
		writeSettleFlag(settleEntity, 1);

		// 推送结算池
		Boolean poolRes = service.pushSettleToPool(BeanMapper.map(settleEntity, SettleVO.class));
		wrapper.set(SettleEntity::getPushPoolFlag, poolRes ? BillPushStatusEnum.推送成功.getStatus() : BillPushStatusEnum.未成功推送.getStatus());

		// 最终结算推送目标成本
		if (Objects.equals(SettleEnum.最终结算.getCode(), settleEntity.getSettleType())) {
			CommonResponse<String> response = executionApi.aggPush(service.targetCost(settleEntity));
			logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(settleEntity)));
			if (!response.isSuccess()){
				logger.error("推送目标成本失败: , {}", response.getMsg());
				throw new BusinessException(response.getMsg());
			}

		}

		// 推送供方
		Boolean pushResult = service.pushBillToSupCenter(settleEntity);
		if(pushResult) {
			wrapper.set(SettleEntity::getBillPushFlag, BillPushStatusEnum.推送成功.getStatus());
		}else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.辅料中心租入合同结算单.getName(), billId);
			wrapper.set(SettleEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		}
		
		// 更新合同池操作
//		Boolean pushResult = service.pushContract(BeanMapper.map(settleEntity, SettleVO.class), UpdateLevelEnum.更新非空字段.getLevelCode());
//		if(pushResult) {
//			updateWrapper.eq(ContractEntity::getPushPoolFlag, BillPushStatusEnum.推送成功.getStatus());
//		} else {
//			updateWrapper.eq(ContractEntity::getPushPoolFlag, BillPushStatusEnum.未成功推送.getStatus());
//		}
//		contractService.update(updateWrapper);
		
		service.update(wrapper);
		
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		SettleEntity entity = service.selectById(billId);

		LambdaQueryWrapper<SettleEntity> wrapper = new LambdaQueryWrapper<>();
		wrapper.ne(SettleEntity::getId, entity.getId());
		wrapper.eq(SettleEntity::getContractId, entity.getContractId());
		wrapper.orderByDesc(SettleEntity::getCreateTime);
		List<SettleEntity> list = service.list(wrapper);

		long count = list.stream().filter(e -> e.getBillState() != 1 && e.getBillState() != 3).count();
		if (count > 0) {
			throw new BusinessException("当前单据存在非审批通过的单据，不能撤回/弃审！");
		}

		if (ListUtil.isNotEmpty(list)) {
			if (!Objects.equals(list.get(0).getId(), billId)) {
				throw new BusinessException("只能撤回/弃审最新一期的结算单！");
			}
		}
		
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		
		// 结算单是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());

		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		SettleEntity entity = service.selectById(billId);
		
		// 回写合同状态
		LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.set(ContractEntity::getContractStatus, ContractStatusEnum.履约中.getCode());
		updateWrapper.eq(ContractEntity::getId, entity.getContractId());
		contractService.update(updateWrapper);
		
		// 回写引用单据结算状态
		writeSettleFlag(entity, 0);
		
		// 从结算池中删除数据
		boolean unPushRes = service.delSettleFromPool(entity.getId());
		if (!unPushRes) {
			entity.setPushPoolFlag(BillPushStatusEnum.未成功推送.getStatus());
		}

		// 删除目标成本
		List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
		ExecutionVO executionVO = service.targetCost(entity);
		totalExecutionVOList.add(executionVO.getTotalVO());
		CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
		if (!response.isSuccess()){
			throw new BusinessException("目标成本删除失败！");
		}
		
		service.saveOrUpdate(entity);
		
		return CommonResponse.success();
	}
	
	public void writeSettleFlag(SettleEntity entity, Integer settleFlag) {
		// 回写租金计算单结算状态
		List<Long> leaseIdsList = new ArrayList<>();
		List<SettleLeaseEntity> leaseList = entity.getLeaseList();
		if (ListUtil.isNotEmpty(leaseList)) {
			leaseIdsList.addAll(leaseList.stream().map(SettleLeaseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(leaseIdsList)) {
			LambdaUpdateWrapper<RentCalculateEntity> leaseWrapper = new LambdaUpdateWrapper<>();
			leaseWrapper.set(RentCalculateEntity::getSettleFlag, settleFlag);
			leaseWrapper.in(RentCalculateEntity::getId, leaseIdsList);
			calculateService.update(leaseWrapper);
		}

		// 回写退赔单、结算单 结算状态
		List<Long> restituteIdsList = new ArrayList<>();
		List<SettleRepairEntity> repairList = entity.getRepairList();
		if (ListUtil.isNotEmpty(repairList)) {
			restituteIdsList.addAll(repairList.stream().map(SettleRepairEntity::getSourceId).collect(Collectors.toList()));
		}
		List<SettleScrapEntity> scrapList = entity.getScrapList();
		if (ListUtil.isNotEmpty(scrapList)) {
			restituteIdsList.addAll(scrapList.stream().map(SettleScrapEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(restituteIdsList)) {
			LambdaUpdateWrapper<RestituteEntity> restituteWrapper = new LambdaUpdateWrapper<>();
			restituteWrapper.set(RestituteEntity::getSettleFlag, settleFlag);
			restituteWrapper.in(RestituteEntity::getId, restituteIdsList);
			restituteService.update(restituteWrapper);
		}

		// 回写遗失单结算状态
		List<SettleLoseEntity> loseList = entity.getLoseList();
		List<Long> loseIdsList = new ArrayList<>();
		if (ListUtil.isNotEmpty(loseList)) {
			loseIdsList.addAll(loseList.stream().map(SettleLoseEntity::getSourceId).collect(Collectors.toList()));
		}
		if (ListUtil.isNotEmpty(loseIdsList)) {
			LambdaUpdateWrapper<LoseEntity> loseWrapper = new LambdaUpdateWrapper<>();
			loseWrapper.set(LoseEntity::getSettleFlag, settleFlag);
			loseWrapper.in(LoseEntity::getId, loseIdsList);
			loseService.update(loseWrapper);
		}
		
	}
	
}
