/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.assist.ownrmat.bean.AllotInDetailEntity;
import com.ejianc.business.assist.ownrmat.bean.AllotInEntity;
import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.service.IAllotInService;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.vo.AllotInVO;
import com.ejianc.business.assist.ownrmat.vo.AllotOutVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="allotOut")
public class AllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAllotInService allotInService;
    private static final String BILL_CODE = "PRO_RMAT_ALLOT_IN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IValidateService validateService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
        AllotOutVO allotOutVO = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
        this.validateService.validateAllotOut(allotOutVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        Jedis jedis = this.jedisPool.getResource();
        boolean locked = false;
        locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
        this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
        if (!locked) return CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        try {
            AllotInEntity allot;
            AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
            AllotOutVO allotOutVO = (AllotOutVO)BeanMapper.map((Object)((Object)allotOutEntity), AllotOutVO.class);
            StoreManageVO storeManageVO = allotOutVO.getStoreManageVO(allotOutVO);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + response.getMsg());
            }
            if (Objects.isNull((Object)allotOutEntity)) return CommonResponse.success();
            if (allotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))) {
                LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
                allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
                allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
                allotOutWrapper.set(AllotOutEntity::getReturnReason, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPerson, null);
                this.service.update((Wrapper)allotOutWrapper);
            }
            AllotInEntity allotInEntity = new AllotInEntity();
            allotInEntity.setOutAllocaScope(allotOutEntity.getOutAllocaScope());
            allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
            allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
            allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
            allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
            allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
            allotInEntity.setInAllocaScope(allotOutEntity.getInAllocaScope());
            allotInEntity.setStoreId(allotOutEntity.getInStoreId());
            allotInEntity.setStoreName(allotOutEntity.getInStoreName());
            allotInEntity.setProjectId(allotOutEntity.getInProjectId());
            allotInEntity.setProjectName(allotOutEntity.getInProjectName());
            allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
            allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
            allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
            allotInEntity.setOrgId(allotOutEntity.getInOrgId());
            allotInEntity.setOrgName(allotOutEntity.getInOrgName());
            allotInEntity.setAllotOutId(allotOutEntity.getId());
            allotInEntity.setOutMny(allotOutEntity.getOutMny());
            allotInEntity.setOutDate(allotOutEntity.getOutDate());
            allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
            allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
            allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
            allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
            allotInEntity.setOutStoreId(allotOutEntity.getStoreId());
            allotInEntity.setOutStoreName(allotOutEntity.getStoreName());
            allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
            allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
            allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
            allotInEntity.setMemo(allotOutEntity.getMemo());
            allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
            allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
            List allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
            long id = IdWorker.getId();
            allotInDetailEntitys.forEach(item -> {
                item.setId(null);
                item.setAllocatId(id);
            });
            allotInEntity.setAllotInDetailList(allotInDetailEntitys);
            AllotInVO vo = (AllotInVO)BeanMapper.map((Object)((Object)allotInEntity), AllotInVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            allotInEntity.setBillCode((String)billCode.getData());
            this.logger.info("\u5b50\u8868\u4fe1\u606f\uff1a" + allotInDetailEntitys.toString());
            allotInEntity.setId(id);
            boolean b = this.allotInService.saveOrUpdate((Object)allotInEntity, false);
            if (!b || (allot = (AllotInEntity)((Object)this.allotInService.selectById(Long.valueOf(id)))) == null || allot.getNotifyReceiverId() == null) return CommonResponse.success();
            String[] stringArray = new String[]{String.valueOf(allot.getNotifyReceiverId())};
            return CommonResponse.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success();
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
            }
            jedis.close();
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

