package com.ejianc.business.assist.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 周转材租赁结算单
 *
 * @author generator
 */
@TableName("ejc_assistrmat_settle")
public class SettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "project_id")
    private Long projectId; // 项目id
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 项目组织id
    @TableField(value = "org_code")
    private String orgCode; // 项目组织编码
    @TableField(value = "org_name")
    private String orgName; // 项目组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "contract_id")
    private Long contractId; // 合同id
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "first_party_id")
    private Long firstPartyId; // 甲方Id
    @TableField(value = "first_party_name")
    private String firstPartyName; // 甲方名称
    @TableField(value = "supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value = "supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value = "rent_calculation_type")
    private String rentCalculationType; // 计租方式：0-日租，1-月租，2-工程量租
    @TableField(value = "month_settlement_day")
    private Integer monthSettlementDay; // 月结算日
    @TableField(value = "settle_type")
    private String settleType; // 结算类型：0-过程结算，1-最终结算
    @TableField(value = "settle_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settleDate; // 结算日期
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人id
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "sup_operate_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value = "supplier_sign_status")
    private Integer supplierSignStatus; // 供方签字状态：0-未签字，1-已签字
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "settle_tax_mny")
    private BigDecimal settleTaxMny; // 本期结算金额
    @TableField(value = "settle_mny")
    private BigDecimal settleMny; // 本期结算金额(无税)
    @TableField(value = "settle_tax")
    private BigDecimal settleTax; // 本期结算税额
    @TableField(value = "lease_tax_mny")
    private Integer leaseTaxMny; // 租赁金额
    @TableField(value = "lease_mny")
    private Integer leaseMny; // 租赁金额(无税)
    @TableField(value = "lease_tax")
    private Integer leaseTax; // 租赁税额
    @TableField(value = "rent_tax_mny")
    private BigDecimal rentTaxMny; // 租金计算单金额
    @TableField(value = "rent_mny")
    private BigDecimal rentMny; // 租金计算单金额(无税)
    @TableField(value = "rent_tax")
    private BigDecimal rentTax; // 租金计算单税额
    @TableField(value = "daily_rent_tax_mny")
    private BigDecimal dailyRentTaxMny; // 日租金额
    @TableField(value = "daily_rent_mny")
    private BigDecimal dailyRentMny; // 日租金额(无税)
    @TableField(value = "daily_rent_tax")
    private BigDecimal dailyRentTax; // 日租税额
    @TableField(value = "month_rent_tax_mny")
    private BigDecimal monthRentTaxMny; // 月租金额
    @TableField(value = "month_rent_mny")
    private BigDecimal monthRentMny; // 月租金额(无税)
    @TableField(value = "month_rent_tax")
    private BigDecimal monthRentTax; // 月租税额
    @TableField(value = "num_rent_tax_mny")
    private BigDecimal numRentTaxMny; // 工程量金额
    @TableField(value = "num_rent_mny")
    private BigDecimal numRentMny; // 工程量金额(无税)
    @TableField(value = "num_rent_tax")
    private BigDecimal numRentTax; // 工程量税额
    @TableField(value = "repair_tax_mny")
    private BigDecimal repairTaxMny; // 维修金额
    @TableField(value = "repair_mny")
    private BigDecimal repairMny; // 维修金额(无税)
    @TableField(value = "repair_tax")
    private BigDecimal repairTax; // 维修税额
    @TableField(value = "scarp_tax_mny")
    private BigDecimal scarpTaxMny; // 报废赔偿金额
    @TableField(value = "scarp_mny")
    private BigDecimal scarpMny; // 报废赔偿金额(无税)
    @TableField(value = "scarp_tax")
    private BigDecimal scarpTax; // 报废赔偿税额
    @TableField(value = "lose_tax_mny")
    private BigDecimal loseTaxMny; // 遗失赔偿金额
    @TableField(value = "lose_mny")
    private BigDecimal loseMny; // 遗失赔偿金额(无税)
    @TableField(value = "lose_tax")
    private BigDecimal loseTax; // 遗失赔偿税额
    @TableField(value = "other_tax_mny")
    private BigDecimal otherTaxMny; // 其他金额
    @TableField(value = "other_mny")
    private BigDecimal otherMny; // 其他金额(无税)
    @TableField(value = "other_tax")
    private BigDecimal otherTax; // 其他税额
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value = "contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value = "contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value = "last_settle_tax_mny")
    private BigDecimal lastSettleTaxMny; // 不含本期已结算金额
    @TableField(value = "last_settle_mny")
    private BigDecimal lastSettleMny; // 不含本期已结算金额(无税)
    @TableField(value = "last_settle_tax")
    private BigDecimal lastSettleTax; // 不含本期已结算税额
    @TableField(value = "total_settle_tax_mny")
    private BigDecimal totalSettleTaxMny; // 含本期已结算金额
    @TableField(value = "total_settle_mny")
    private BigDecimal totalSettleMny; // 含本期已结算金额(无税)
    @TableField(value = "total_settle_tax")
    private BigDecimal totalSettleTax; // 含本期已结算税额
    @TableField(value = "total_pay_tax_mny")
    private BigDecimal totalPayTaxMny; // 累计已付金额
    @TableField(value = "total_pay_mny")
    private BigDecimal totalPayMny; // 累计已付金额(无税)
    @TableField(value = "total_pay_tax")
    private BigDecimal totalPayTax; // 累计已付税额
    @TableField(value = "total_invoice_tax_mny")
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额
    @TableField(value = "total_invoice_mny")
    private BigDecimal totalInvoiceMny; // 累计收票金额(无税)
    @TableField(value = "total_invoice_tax")
    private BigDecimal totalInvoiceTax; // 累计收票税额
    @TableField(value = "contract_pay_rate")
    private BigDecimal contractPayRate; // 合同支付比例
    @TableField(value = "commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交时间
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_user_code")
    private String commitUserCode; // 提交人账号
    
    @TableField(value = "contract_tax_rate")
    private BigDecimal contractTaxRate; // 合同税率
    @TableField(value = "contract_code")
    private String contractCode; // 合同编号
    @TableField(value = "push_pool_flag")
    private String pushPoolFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 推送供方状态：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value = "sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号 
    
    
    @TableField(exist = false)
    @SubEntity(serviceName = "settleLeaseService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleLeaseEntity> leaseList = new ArrayList<>(); // 结算单-租赁金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleDailyRentEntutyService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleDailyRentEntity> dailyRentList = new ArrayList<>(); // 结算单-日租金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleMonthRentService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleMonthRentEntity> monthRentList = new ArrayList<>(); // 结算单-月租金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleNumRentService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleNumRentEntity> numRentList = new ArrayList<>(); // 结算单-工程量租金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleRepairService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleRepairEntity> repairList = new ArrayList<>(); // 结算单-维修金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleScrapService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleScrapEntity> scrapList = new ArrayList<>(); // 结算单-报废赔偿金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleLoseService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleLoseEntity> loseList = new ArrayList<>(); // 结算单-遗失赔偿金额
    @TableField(exist = false)
    @SubEntity(serviceName = "settleOtherService", pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<SettleOtherEntity> otherList = new ArrayList<>(); // 结算单-其他费用


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getRentCalculationType() {
        return rentCalculationType;
    }

    public void setRentCalculationType(String rentCalculationType) {
        this.rentCalculationType = rentCalculationType;
    }

    public Integer getMonthSettlementDay() {
        return monthSettlementDay;
    }

    public void setMonthSettlementDay(Integer monthSettlementDay) {
        this.monthSettlementDay = monthSettlementDay;
    }

    public String getSettleType() {
        return settleType;
    }

    public void setSettleType(String settleType) {
        this.settleType = settleType;
    }

    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public Integer getLeaseTaxMny() {
        return leaseTaxMny;
    }

    public void setLeaseTaxMny(Integer leaseTaxMny) {
        this.leaseTaxMny = leaseTaxMny;
    }

    public Integer getLeaseMny() {
        return leaseMny;
    }

    public void setLeaseMny(Integer leaseMny) {
        this.leaseMny = leaseMny;
    }

    public Integer getLeaseTax() {
        return leaseTax;
    }

    public void setLeaseTax(Integer leaseTax) {
        this.leaseTax = leaseTax;
    }

    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }

    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }

    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }

    public BigDecimal getDailyRentTaxMny() {
        return dailyRentTaxMny;
    }

    public void setDailyRentTaxMny(BigDecimal dailyRentTaxMny) {
        this.dailyRentTaxMny = dailyRentTaxMny;
    }

    public BigDecimal getDailyRentMny() {
        return dailyRentMny;
    }

    public void setDailyRentMny(BigDecimal dailyRentMny) {
        this.dailyRentMny = dailyRentMny;
    }

    public BigDecimal getDailyRentTax() {
        return dailyRentTax;
    }

    public void setDailyRentTax(BigDecimal dailyRentTax) {
        this.dailyRentTax = dailyRentTax;
    }

    public BigDecimal getMonthRentTaxMny() {
        return monthRentTaxMny;
    }

    public void setMonthRentTaxMny(BigDecimal monthRentTaxMny) {
        this.monthRentTaxMny = monthRentTaxMny;
    }

    public BigDecimal getMonthRentMny() {
        return monthRentMny;
    }

    public void setMonthRentMny(BigDecimal monthRentMny) {
        this.monthRentMny = monthRentMny;
    }

    public BigDecimal getMonthRentTax() {
        return monthRentTax;
    }

    public void setMonthRentTax(BigDecimal monthRentTax) {
        this.monthRentTax = monthRentTax;
    }

    public BigDecimal getNumRentTaxMny() {
        return numRentTaxMny;
    }

    public void setNumRentTaxMny(BigDecimal numRentTaxMny) {
        this.numRentTaxMny = numRentTaxMny;
    }

    public BigDecimal getNumRentMny() {
        return numRentMny;
    }

    public void setNumRentMny(BigDecimal numRentMny) {
        this.numRentMny = numRentMny;
    }

    public BigDecimal getNumRentTax() {
        return numRentTax;
    }

    public void setNumRentTax(BigDecimal numRentTax) {
        this.numRentTax = numRentTax;
    }

    public BigDecimal getRepairTaxMny() {
        return repairTaxMny;
    }

    public void setRepairTaxMny(BigDecimal repairTaxMny) {
        this.repairTaxMny = repairTaxMny;
    }

    public BigDecimal getRepairMny() {
        return repairMny;
    }

    public void setRepairMny(BigDecimal repairMny) {
        this.repairMny = repairMny;
    }

    public BigDecimal getRepairTax() {
        return repairTax;
    }

    public void setRepairTax(BigDecimal repairTax) {
        this.repairTax = repairTax;
    }

    public BigDecimal getScarpTaxMny() {
        return scarpTaxMny;
    }

    public void setScarpTaxMny(BigDecimal scarpTaxMny) {
        this.scarpTaxMny = scarpTaxMny;
    }

    public BigDecimal getScarpMny() {
        return scarpMny;
    }

    public void setScarpMny(BigDecimal scarpMny) {
        this.scarpMny = scarpMny;
    }

    public BigDecimal getScarpTax() {
        return scarpTax;
    }

    public void setScarpTax(BigDecimal scarpTax) {
        this.scarpTax = scarpTax;
    }

    public BigDecimal getLoseTaxMny() {
        return loseTaxMny;
    }

    public void setLoseTaxMny(BigDecimal loseTaxMny) {
        this.loseTaxMny = loseTaxMny;
    }

    public BigDecimal getLoseMny() {
        return loseMny;
    }

    public void setLoseMny(BigDecimal loseMny) {
        this.loseMny = loseMny;
    }

    public BigDecimal getLoseTax() {
        return loseTax;
    }

    public void setLoseTax(BigDecimal loseTax) {
        this.loseTax = loseTax;
    }

    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }

    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }

    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getLastSettleTaxMny() {
        return lastSettleTaxMny;
    }

    public void setLastSettleTaxMny(BigDecimal lastSettleTaxMny) {
        this.lastSettleTaxMny = lastSettleTaxMny;
    }

    public BigDecimal getLastSettleMny() {
        return lastSettleMny;
    }

    public void setLastSettleMny(BigDecimal lastSettleMny) {
        this.lastSettleMny = lastSettleMny;
    }

    public BigDecimal getLastSettleTax() {
        return lastSettleTax;
    }

    public void setLastSettleTax(BigDecimal lastSettleTax) {
        this.lastSettleTax = lastSettleTax;
    }

    public BigDecimal getTotalSettleTaxMny() {
        return totalSettleTaxMny;
    }

    public void setTotalSettleTaxMny(BigDecimal totalSettleTaxMny) {
        this.totalSettleTaxMny = totalSettleTaxMny;
    }

    public BigDecimal getTotalSettleMny() {
        return totalSettleMny;
    }

    public void setTotalSettleMny(BigDecimal totalSettleMny) {
        this.totalSettleMny = totalSettleMny;
    }

    public BigDecimal getTotalSettleTax() {
        return totalSettleTax;
    }

    public void setTotalSettleTax(BigDecimal totalSettleTax) {
        this.totalSettleTax = totalSettleTax;
    }

    public BigDecimal getTotalPayTaxMny() {
        return totalPayTaxMny;
    }

    public void setTotalPayTaxMny(BigDecimal totalPayTaxMny) {
        this.totalPayTaxMny = totalPayTaxMny;
    }

    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }

    public BigDecimal getTotalPayTax() {
        return totalPayTax;
    }

    public void setTotalPayTax(BigDecimal totalPayTax) {
        this.totalPayTax = totalPayTax;
    }

    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }

    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }

    public BigDecimal getTotalInvoiceTax() {
        return totalInvoiceTax;
    }

    public void setTotalInvoiceTax(BigDecimal totalInvoiceTax) {
        this.totalInvoiceTax = totalInvoiceTax;
    }

    public BigDecimal getContractPayRate() {
        return contractPayRate;
    }

    public void setContractPayRate(BigDecimal contractPayRate) {
        this.contractPayRate = contractPayRate;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getPushPoolFlag() {
        return pushPoolFlag;
    }

    public void setPushPoolFlag(String pushPoolFlag) {
        this.pushPoolFlag = pushPoolFlag;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public List<SettleLeaseEntity> getLeaseList() {
        return leaseList;
    }

    public void setLeaseList(List<SettleLeaseEntity> leaseList) {
        this.leaseList = leaseList;
    }

    public List<SettleDailyRentEntity> getDailyRentList() {
        return dailyRentList;
    }

    public void setDailyRentList(List<SettleDailyRentEntity> dailyRentList) {
        this.dailyRentList = dailyRentList;
    }

    public List<SettleMonthRentEntity> getMonthRentList() {
        return monthRentList;
    }

    public void setMonthRentList(List<SettleMonthRentEntity> monthRentList) {
        this.monthRentList = monthRentList;
    }

    public List<SettleNumRentEntity> getNumRentList() {
        return numRentList;
    }

    public void setNumRentList(List<SettleNumRentEntity> numRentList) {
        this.numRentList = numRentList;
    }

    public List<SettleRepairEntity> getRepairList() {
        return repairList;
    }

    public void setRepairList(List<SettleRepairEntity> repairList) {
        this.repairList = repairList;
    }

    public List<SettleScrapEntity> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<SettleScrapEntity> scrapList) {
        this.scrapList = scrapList;
    }

    public List<SettleLoseEntity> getLoseList() {
        return loseList;
    }

    public void setLoseList(List<SettleLoseEntity> loseList) {
        this.loseList = loseList;
    }

    public List<SettleOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<SettleOtherEntity> otherList) {
        this.otherList = otherList;
    }
}
