/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.ownrmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.assist.ownrmat.bean.AllotOutEntity;
import com.ejianc.business.assist.ownrmat.bean.AmortizationEntity;
import com.ejianc.business.assist.ownrmat.bean.HandleEntity;
import com.ejianc.business.assist.ownrmat.bean.OwnDetailEntity;
import com.ejianc.business.assist.ownrmat.bean.OwnEntity;
import com.ejianc.business.assist.ownrmat.mapper.OwnMapper;
import com.ejianc.business.assist.ownrmat.service.IAllotOutService;
import com.ejianc.business.assist.ownrmat.service.IAmortizationService;
import com.ejianc.business.assist.ownrmat.service.IHandleService;
import com.ejianc.business.assist.ownrmat.service.IOwnDetailService;
import com.ejianc.business.assist.ownrmat.service.IOwnService;
import com.ejianc.business.assist.ownrmat.service.IValidateService;
import com.ejianc.business.assist.ownrmat.utils.MathUtil;
import com.ejianc.business.assist.ownrmat.vo.OwnDetailVO;
import com.ejianc.business.assist.ownrmat.vo.OwnVO;
import com.ejianc.business.assist.ownrmat.vo.ResidualVO;
import com.ejianc.business.assist.rmat.utils.DateUtil;
import com.ejianc.business.assist.rmat.utils.ValidateUtil;
import com.ejianc.business.store.api.IStoreFlowApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ownService")
public class OwnServiceImpl
extends BaseServiceImpl<OwnMapper, OwnEntity>
implements IOwnService {
    private static final String BILL_CODE = "PRO_OWNRMAT_OWN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOwnDetailService ownDetailService;
    @Autowired
    private IStoreFlowApi storeFlowApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAmortizationService amortizationService;
    @Autowired
    private IAllotOutService allotOutService;
    @Autowired
    private IHandleService handleService;
    @Autowired
    private IValidateService validateContract;

    @Override
    public OwnVO saveOrUpdate(OwnVO saveorUpdateVO) {
        List detailEntityList;
        this.validateContract.validateProject(saveorUpdateVO.getProjectId(), "\u81ea\u6709\u6750\u6599\u644a\u9500", saveorUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveorUpdateVO, "\u4fdd\u5b58");
        Long tenantId = InvocationInfoProxy.getTenantid();
        OwnEntity entity = null;
        String operateType = null;
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(OwnEntity::getProjectId, (Object)saveorUpdateVO.getProjectId());
        lambd.notIn(OwnEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "edit";
            lambd.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (OwnEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OwnEntity.class));
            operateType = "add";
        }
        List list = super.list((Wrapper)lambd);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u4e0a\u4e0b\u6587\u7ec4\u7ec7\u6709\u672a\u751f\u6548\u7684\u644a\u9500\u5355\uff0c\u4e0d\u80fd\u65b0\u589e\u644a\u9500\u5355");
        }
        List detailList = saveorUpdateVO.getOwnDetailList();
        String categoryName = "";
        ArrayList<String> nameList = new ArrayList<String>();
        for (OwnDetailVO detailVO : detailList) {
            if (nameList.contains(detailVO.getMaterialTypeName())) continue;
            categoryName = categoryName.length() > 0 ? categoryName + "," + detailVO.getMaterialTypeName() : detailVO.getMaterialTypeName();
            nameList.add(detailVO.getMaterialTypeName());
            if (categoryName.length() <= 100) continue;
            break;
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((OwnMapper)this.baseMapper).delByBatchId(entity.getId());
        }
        if ((detailEntityList = BeanMapper.mapList((Iterable)detailList, OwnDetailEntity.class)).size() > 0) {
            for (OwnDetailEntity detailEntity : detailEntityList) {
                detailEntity.setOwnId(entity.getId());
            }
            this.ownDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    private Boolean allotOutCheck(Long projectId) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(AllotOutEntity::getProjectId, (Object)projectId);
        lambd.notIn(AllotOutEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.allotOutService.list((Wrapper)lambd);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    private Boolean handleCheck(Long projectId) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(HandleEntity::getProjectId, (Object)projectId);
        lambd.notIn(HandleEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List list = this.handleService.list((Wrapper)lambd);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public String validateTime(OwnVO startVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("projectId", startVO.getProjectId());
        if (startVO.getId() != null) {
            params.put("billType", "\u81ea\u6709\u6750\u6599\u644a\u9500");
            params.put("billId", startVO.getId());
        }
        Date lastDate = this.validateContract.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.validateContract.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(startVO.getProcessingDate(), lastDate, maxTimeMap, startVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(startVO.getProcessingDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public OwnVO queryDetail(Long id) {
        OwnEntity batchPlanEntity = (OwnEntity)((Object)super.selectById((Serializable)id));
        OwnVO vo = (OwnVO)BeanMapper.map((Object)((Object)batchPlanEntity), OwnVO.class);
        return vo;
    }

    @Override
    public List<OwnDetailVO> refAmortizationList(QueryParam param, Long orgId, String amortizationCycle) {
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        ArrayList<Integer> inOutType = new ArrayList<Integer>();
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutType());
        inOutType.add(InOutTypeEnum.\u5468\u8f6c\u6750\u8c03\u62e8\u5165\u5e93.getInOutType());
        param.getParams().put("inOutType", new Parameter("in", inOutType));
        param.getParams().put("inOutFlag", new Parameter("eq", (Object)InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.getInOutFlag()));
        CommonResponse flowListResponse = this.storeFlowApi.getFlowList(param);
        List flowList = new ArrayList();
        if (!flowListResponse.isSuccess()) {
            throw new BusinessException(flowListResponse.getMsg());
        }
        flowList = (List)flowListResponse.getData();
        ArrayList<OwnDetailVO> res = new ArrayList<OwnDetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (FlowVO vo : flowList) {
            BigDecimal num = MathUtil.safeAdd(vo.getOutLockNum(), vo.getSurplusNum());
            if (num == null) {
                num = BigDecimal.ZERO;
            }
            if (num.compareTo(BigDecimal.ZERO) <= 0 || vo.getNetTaxMny() == null || vo.getNetTaxMny().compareTo(BigDecimal.ZERO) <= 0 || (vo.getLastShareDate() != null || DateUtil.compareDateStr(amortizationCycle, sdf.format(vo.getSourceBillDate())) < 0) && (vo.getLastShareDate() == null || DateUtil.compareDateStr(amortizationCycle, sdf.format(vo.getLastShareDate())) <= 0)) continue;
            BigDecimal purchasePrice = vo.getPurchasePrice() == null ? BigDecimal.ZERO : vo.getPurchasePrice();
            BigDecimal purchaseTaxPrice = vo.getPurchaseTaxPrice() == null ? BigDecimal.ZERO : vo.getPurchaseTaxPrice();
            OwnDetailVO detailVO = new OwnDetailVO();
            detailVO.setSourceCode(vo.getBillCode());
            detailVO.setMaterialTypeId(vo.getMaterialCategoryId());
            detailVO.setMaterialTypeCode(vo.getMaterialCategoryCode());
            detailVO.setMaterialTypeName(vo.getMaterialCategoryName());
            detailVO.setMaterialId(vo.getMaterialId());
            detailVO.setMaterialCode(vo.getMaterialCode());
            detailVO.setMaterialName(vo.getMaterialName());
            detailVO.setSpec(vo.getMaterialSpec());
            detailVO.setUnitId(vo.getMaterialUnitId());
            detailVO.setUnit(vo.getMaterialUnitName());
            detailVO.setOriginalValue(MathUtil.safeMultiply(num, purchasePrice));
            detailVO.setOriginalValueTax(MathUtil.safeMultiply(num, purchaseTaxPrice));
            detailVO.setNetWorth(vo.getNetMny() == null ? BigDecimal.ZERO : vo.getNetMny());
            detailVO.setNetWorthTax(vo.getNetTaxMny() == null ? BigDecimal.ZERO : vo.getNetTaxMny());
            detailVO.setResidualValue(null);
            detailVO.setResidualValueTax(null);
            detailVO.setOriginalValuePrice(purchasePrice);
            detailVO.setOriginalValuePriceTax(purchaseTaxPrice);
            BigDecimal taxRate = MathUtil.safeSub(MathUtil.safeDiv(detailVO.getOriginalValueTax(), detailVO.getOriginalValue()), BigDecimal.ONE);
            taxRate = taxRate.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : MathUtil.safeMultiply(taxRate, new BigDecimal(100));
            detailVO.setTaxRate(taxRate);
            detailVO.setNum(num);
            detailVO.setLastAmortizationCycle(vo.getLastShareDate() == null ? null : sdf.format(vo.getLastShareDate()));
            detailVO.setAmortizationRate(null);
            detailVO.setAmortizationMny(null);
            detailVO.setAmortizationMnyTax(null);
            detailVO.setMemo(vo.getSourceBillDetailRemark());
            detailVO.setSourceId(vo.getId());
            int amortizationNum = 0;
            int usedAmortizationNum = 0;
            if (vo.getLastShareDate() != null) {
                amortizationNum = DateUtil.subMonth(sdf.format(vo.getLastShareDate()), amortizationCycle, sdf);
                usedAmortizationNum = DateUtil.subMonth(sdf.format(vo.getSourceBillDate()), sdf.format(vo.getLastShareDate()), sdf) + 1;
            } else {
                amortizationNum = DateUtil.subMonth(sdf.format(vo.getSourceBillDate()), amortizationCycle, sdf) + 1;
            }
            detailVO.setAmortizationNum(Integer.valueOf(amortizationNum));
            detailVO.setUsedAmortizationNum(Integer.valueOf(usedAmortizationNum));
            detailVO.setFlowSourceId(vo.getSourceId());
            detailVO.setFlowSourceDetailId(vo.getSourceDetailId());
            res.add(detailVO);
            materialIds.add(vo.getMaterialId());
        }
        if (res.size() > 0) {
            ResidualVO vo = new ResidualVO();
            vo.setOrgId(orgId);
            vo.setMaterialIds(materialIds);
            Map<Long, AmortizationEntity> residualRate = this.amortizationService.getResidualRate(vo);
            if (residualRate.size() > 0) {
                for (OwnDetailVO detailVO : res) {
                    if (residualRate.containsKey(detailVO.getMaterialId())) {
                        detailVO.setUsePeriod(residualRate.get(detailVO.getMaterialId()).getUsePeriod());
                        detailVO.setResidualValueRate(residualRate.get(detailVO.getMaterialId()).getResidualValueRate());
                        detailVO.setResidualValue(MathUtil.safeMultiply(detailVO.getOriginalValue(), MathUtil.safeDiv(detailVO.getResidualValueRate(), new BigDecimal(100))));
                        detailVO.setResidualValueTax(MathUtil.safeMultiply(detailVO.getOriginalValueTax(), MathUtil.safeDiv(detailVO.getResidualValueRate(), new BigDecimal(100))));
                        continue;
                    }
                    detailVO.setResidualValue(BigDecimal.ZERO);
                    detailVO.setResidualValueTax(BigDecimal.ZERO);
                }
            }
        }
        return res;
    }

    @Override
    public String getLastAmortizationCycle(Long projectId, Long id) {
        String lastAmortizationCycle = ((OwnMapper)this.baseMapper).getLastAmortizationCycle(projectId, id);
        return lastAmortizationCycle;
    }
}

