package com.ejianc.business.assist.material.service.impl;

import com.ejianc.business.assist.material.bean.MaterialBatchPlanDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialBatchPlanEntity;
import com.ejianc.business.assist.material.mapper.MaterialBatchPlanMapper;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanDetailService;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanService;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanDetailVO;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 周转材批次计划
 *
 * @author generator
 */
@Service("materialBatchPlanService")
public class MaterialBatchPlanServiceImpl extends BaseServiceImpl<MaterialBatchPlanMapper, MaterialBatchPlanEntity> implements IMaterialBatchPlanService {
    private static final String BILL_CODE = "ASSISTRMAT_BATCH_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialBatchPlanDetailService batchPlanDetailService;

    @Override
    public MaterialBatchPlanVO saveOrUpdate(MaterialBatchPlanVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialBatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(0);
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            entity = BeanMapper.map(saveorUpdateVO, MaterialBatchPlanEntity.class);
            operateType = "edit";
        } else {
            //新增
            if (StringUtils.isEmpty(saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveorUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            entity = BeanMapper.map(saveorUpdateVO, MaterialBatchPlanEntity.class);
            operateType = "add";
        }
        List<MaterialBatchPlanDetailVO> detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        List<String> nameList = new ArrayList<>();
        for (MaterialBatchPlanDetailVO detailVO : detailList) {
            if (!nameList.contains(detailVO.getMaterialTypeName())) {
                if (categoryName.length() > 0) {
                    categoryName = categoryName + "," + detailVO.getMaterialTypeName();
                } else {
                    categoryName = detailVO.getMaterialTypeName();
                }
                nameList.add(detailVO.getMaterialTypeName());
                if (categoryName.length() > 100) {
                    break;
                }
            }
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate(entity);
        //更新子表信息
        if ("edit".equals(operateType)) {
            baseMapper.delByBatchId(entity.getId());
        }
        List<MaterialBatchPlanDetailEntity> detailEntityList = BeanMapper.mapList(detailList,MaterialBatchPlanDetailEntity.class);
        if (detailEntityList.size() > 0) {
            for(MaterialBatchPlanDetailEntity detailEntity : detailEntityList){
                detailEntity.setBatchId(entity.getId());
            }
            batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return queryDetail(entity.getId());
    }

    @Override
    public MaterialBatchPlanVO queryDetail(Long id) {
        MaterialBatchPlanEntity MaterialBatchPlanEntity = super.selectById(id);
        MaterialBatchPlanVO vo = BeanMapper.map(MaterialBatchPlanEntity,MaterialBatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(MaterialBatchPlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<MaterialBatchPlanEntity> entityList = (List<MaterialBatchPlanEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (MaterialBatchPlanEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (MaterialBatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】项目名称【" +
                                entity.getProjectName() + "】已采购完成！");
                    }

                    entity.setTenderStatus(planState);
                }
//                entityList.forEach(entity -> {
//                    entity.setPlanState(planState);
//                });
                super.saveOrUpdateBatch(entityList);
            }
        }
    }
}
