/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.material.service.impl;

import com.ejianc.business.assist.material.bean.MaterialBatchPlanDetailEntity;
import com.ejianc.business.assist.material.bean.MaterialBatchPlanEntity;
import com.ejianc.business.assist.material.mapper.MaterialBatchPlanMapper;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanDetailService;
import com.ejianc.business.assist.material.service.IMaterialBatchPlanService;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanDetailVO;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialBatchPlanService")
public class MaterialBatchPlanServiceImpl
extends BaseServiceImpl<MaterialBatchPlanMapper, MaterialBatchPlanEntity>
implements IMaterialBatchPlanService {
    private static final String BILL_CODE = "ASSISTRMAT_BATCH_PLAN_CODE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialBatchPlanDetailService batchPlanDetailService;

    @Override
    public MaterialBatchPlanVO saveOrUpdate(MaterialBatchPlanVO saveorUpdateVO) {
        List detailEntityList;
        Long tenantId = InvocationInfoProxy.getTenantid();
        MaterialBatchPlanEntity entity = null;
        String operateType = null;
        saveorUpdateVO.setTenderStatus(Integer.valueOf(0));
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            entity = (MaterialBatchPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MaterialBatchPlanEntity.class));
            operateType = "edit";
        } else {
            if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getBillCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    saveorUpdateVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            entity = (MaterialBatchPlanEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, MaterialBatchPlanEntity.class));
            operateType = "add";
        }
        List detailList = saveorUpdateVO.getDetailList();
        String categoryName = "";
        ArrayList<String> nameList = new ArrayList<String>();
        for (MaterialBatchPlanDetailVO detailVO : detailList) {
            if (nameList.contains(detailVO.getMaterialTypeName())) continue;
            categoryName = categoryName.length() > 0 ? categoryName + "," + detailVO.getMaterialTypeName() : detailVO.getMaterialTypeName();
            nameList.add(detailVO.getMaterialTypeName());
            if (categoryName.length() <= 100) continue;
            break;
        }
        entity.setCategoryName(categoryName);
        super.saveOrUpdate((Object)entity);
        if ("edit".equals(operateType)) {
            ((MaterialBatchPlanMapper)this.baseMapper).delByBatchId(entity.getId());
        }
        if ((detailEntityList = BeanMapper.mapList((Iterable)detailList, MaterialBatchPlanDetailEntity.class)).size() > 0) {
            for (MaterialBatchPlanDetailEntity detailEntity : detailEntityList) {
                detailEntity.setBatchId(entity.getId());
            }
            this.batchPlanDetailService.saveOrUpdateBatch(detailEntityList, detailEntityList.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public MaterialBatchPlanVO queryDetail(Long id) {
        MaterialBatchPlanEntity MaterialBatchPlanEntity2 = (MaterialBatchPlanEntity)((Object)super.selectById((Serializable)id));
        MaterialBatchPlanVO vo = (MaterialBatchPlanVO)BeanMapper.map((Object)((Object)MaterialBatchPlanEntity2), MaterialBatchPlanVO.class);
        return vo;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)MaterialBatchPlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (MaterialBatchPlanEntity entity : entityList) {
                if (MaterialBatchPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getTenderStatus())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u9879\u76ee\u540d\u79f0\u3010" + entity.getProjectName() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setTenderStatus(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }
}

