package com.ejianc.business.assist.material.utils;

import java.util.Date;
import java.util.Map;

/**
 * 校验工具类
 */
public class ValidateUtil {

    /**
     * 比较时间大小，单据日期与最大单据日期比，相同单据日期，制单日期与最大制单日期比
     * @param date1 单据日期
     * @param date2 最大单据日期
     * @param maxTimeMap 最大制单日期Map
     * @param createTime 制单日期
     * @return
     */
    public static boolean compareDate (Date date1, Date date2, Map<Date, Date> maxTimeMap, Date createTime) {
        if(date1 == null || date2 == null){
            return false;
        }
        if(DateUtil.compareDate(date1, date2) < 0){
            return true;
        }
        if(DateUtil.compareDate(date1, date2) == 0) {
            Date maxTime = maxTimeMap.get(date1);
            if(createTime == null || maxTime == null){
                return false;
            }
            if(DateUtil.compareDate(createTime, maxTime) < 0){
                return true;
            }
        }
        return false;
    }

}
