/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.assist.rmat.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.assist.rmat.bean.DeliveryEntity;
import com.ejianc.business.assist.rmat.bean.OrderDetailEntity;
import com.ejianc.business.assist.rmat.bean.OrderEntity;
import com.ejianc.business.assist.rmat.enums.BillTypeEnum;
import com.ejianc.business.assist.rmat.mapper.DeliveryMapper;
import com.ejianc.business.assist.rmat.mapper.OrderMapper;
import com.ejianc.business.assist.rmat.service.IOrderService;
import com.ejianc.business.assist.rmat.utils.PushSupUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    @Autowired
    private PushSupUtil pushSupUtil;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private DeliveryMapper deliveryMapper;
    private static final String OPERATE = "ORDER_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u79df\u8d41\u8ba2\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u79df\u8d41\u8ba2\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/order/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/order/billDel";
    private static final String CHANGE_CLOSE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/order/changeCloseState";

    @Override
    public boolean pushBillToSupCenter(OrderEntity entity) {
        Boolean syncFlag = this.pushSupUtil.pushBillToSupCenter((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, PUSH_BILL_SERVER_URL);
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.valueOf(request.getParameter("supOperateTime")));
        String denialReason = request.getParameter("denialReason");
        String receiveState = request.getParameter("receiveState");
        String deliverState = request.getParameter("deliverState");
        String transData = request.getParameter("orderDetailList");
        List orderDetailList = JSONArray.parseArray((String)transData, OrderDetailEntity.class);
        Map collect = orderDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (k1, k2) -> k2));
        this.logger.info("\u63a5\u6536\u5230\u5355\u636e\u6210\u529f\u63a5\u6536\u901a\u77e5\uff1aid-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, orderDetailList-{}", new Object[]{billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, orderDetailList.toString()});
        OrderEntity entity = (OrderEntity)((Object)super.selectById((Serializable)((Object)billId)));
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        String key = BILL_TYPE + "::" + entity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u4f5c\u5e9f\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, OPERATE);
                String string = "\u5355\u636e\u63a5\u6536\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01";
                return string;
            }
            entity.setDenialReason(denialReason);
            entity.setReceiveState(receiveState);
            entity.setDeliverState(deliverState);
            for (OrderDetailEntity detailEntity : entity.getOrderDetailList()) {
                if (collect.get(detailEntity.getId()) == null) continue;
                OrderDetailEntity detail = (OrderDetailEntity)((Object)collect.get(detailEntity.getId()));
                detailEntity.setReceiveNumsSum(detail.getReceiveNumsSum());
                detailEntity.setNotDeliveredNumsSum(detail.getReceiveNumsSum());
            }
            super.saveOrUpdate((Object)entity, false);
            String msgSendResult = this.sendMsg(entity, "\u4f9b\u65b9\u5df2\u786e\u8ba4\u63d0\u9192", "\u79df\u8d41\u8ba2\u5355[" + entity.getBillCode() + "]\u4f9b\u65b9\u5df2\u786e\u8ba4\u5b8c\u6210");
            if (null != msgSendResult) {
                String createUserId = PushSupUtil.getCreateUserId(entity.getCreateUserCode());
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u63a5\u6536\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])new Serializable[]{createUserId, entity.getLinkId()}), entity.getId(), msgSendResult});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u63a5\u6536\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)entity.getId(), (Object)e);
            msg = "\u5355\u636e\u63a5\u6536\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }

    @Override
    public boolean delPushBill(OrderEntity entity) {
        Boolean delSuc = this.pushSupUtil.delPushBill((JSONObject)JSONObject.toJSON((Object)((Object)entity)), OPERATE, BILL_TYPE, BILL_NAME, DEL_SUP_BILL_SERVER_URL);
        return delSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private String sendMsg(OrderEntity entity, String subject, String content) {
        String createUserId = PushSupUtil.getCreateUserId(entity.getCreateUserCode());
        Object[] msgRecUserIds = new String[]{createUserId, entity.getLinkId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setReceivers((String[])msgRecUserIds);
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(entity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    @Override
    public String validateClose(OrderEntity entity) {
        List<DeliveryEntity> deliveryEntities;
        String msg = null;
        if ("0".equals(entity.getReceiveState()) || "3".equals(entity.getReceiveState())) {
            msg = "\u8ba2\u5355\u72b6\u6001\u4e3a\u5f85\u63a5\u6536\u6216\u4e0d\u4e88\u63a5\u6536\uff0c\u8ba2\u5355\u4e0d\u53ef\u5173\u95ed\uff01";
        }
        if ("2".equals(entity.getDeliverState())) {
            msg = "\u8ba2\u5355\u72b6\u6001\u4e3a\u5168\u90e8\u9001\u8d27\uff0c\u8ba2\u5355\u4e0d\u53ef\u5173\u95ed\uff01";
        }
        if (CollectionUtils.isNotEmpty(deliveryEntities = this.deliveryMapper.selectDeliveryList(entity.getId(), "2", "0"))) {
            msg = "\u8ba2\u5355\u5b58\u5728\u672a\u5168\u90e8\u9a8c\u6536\u7684\u9001\u8d27\u5355\u6216\u5b58\u5728\u672a\u5173\u95ed\u7684\u9001\u8d27\u5355\uff0c\u8ba2\u5355\u4e0d\u53ef\u5173\u95ed\uff01";
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ChangeCloseState(OrderEntity entity) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = BILL_TYPE + "::" + entity.getId().toString() + "::sup";
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.releaseLock(jedis, false, key, OPERATE);
                String string = "\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01";
                return string;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("billId", entity.getId().toString());
            HashMap files = new HashMap();
            this.logger.info("\u53c2\u6570-{}\uff0c\u4f9b\u65b9-{}", (Object)JSONObject.toJSONString(params), (Object)entity.getSupplierId().toString());
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(CHANGE_CLOSE_BILL_SERVER_URL, params, entity.getSupplierId().toString(), files);
            this.logger.error("\u5355\u636e-{}\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                String string = BILL_NAME + "\u6821\u9a8c\u5173\u95ed\u53d1\u9001\u8bf7\u6c42\u5931\u8d25";
                return string;
            }
            if (noPower.equals(backResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u4f9b\u5e94\u5546-{}\u5931\u8d25, {}", new Object[]{CHANGE_CLOSE_BILL_SERVER_URL, entity.getSupplierId(), backResp.getData()});
                String string = (String)backResp.getData();
                return string;
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(OrderEntity::getDisableState, (Object)"1");
            super.update((Wrapper)updateWrapper);
        }
        catch (Exception e) {
            msg = "\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, OPERATE);
        }
        return msg;
    }
}

