package com.ejianc.business.assist.rmat.service;

import com.ejianc.business.assist.rmat.bean.ChangeEntity;
import com.ejianc.business.assist.rmat.vo.ChangeVO;
import com.ejianc.business.assist.rmat.vo.ContractVO;
import com.ejianc.business.assist.rmat.vo.record.ChangeRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 周转材租赁合同变更表
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    ChangeVO saveOrUpdate(@RequestBody ChangeVO saveOrUpdateVO);

    ChangeRecordVO queryChangeRecord(Long id);

    ChangeVO queryContractRecordDetail(Long id);
    
    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState);


    void deleteByIds(List<ChangeVO> vos);

    Map<String, Object> queryChangeCompare(Long id);

    Boolean pushContract(ContractVO vo, String updateLevel);


}
